/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.util;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.secconv.WSSCElementFactory;
import com.sun.xml.ws.security.secconv.WSSCElementFactory13;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustSOAPFaultException;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.bindings.AttributedURI;
import com.sun.xml.ws.security.trust.impl.bindings.EndpointReference;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.SAMLAssertionFactory;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSTrustUtil {
    private WSTrustUtil() {
    }

    public static SOAPFault createSOAP11Fault(WSTrustSOAPFaultException sfex) {
        throw new UnsupportedOperationException("To Do");
    }

    public static SOAPFault createSOAP12Fault(WSTrustSOAPFaultException sfex) {
        throw new UnsupportedOperationException("To Do");
    }

    public static byte[] generateRandomSecret(int keySize) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[keySize];
        random.nextBytes(secret);
        return secret;
    }

    public static SecurityContextToken createSecurityContextToken(WSTrustElementFactory wsscEleFac) throws WSSecureConversationException {
        URI idURI;
        String identifier = "urn:uuid:" + UUID.randomUUID().toString();
        try {
            idURI = new URI(identifier);
        }
        catch (URISyntaxException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
        String wsuId = "uuid-" + UUID.randomUUID().toString();
        if (wsscEleFac instanceof WSSCElementFactory) {
            return ((WSSCElementFactory)wsscEleFac).createSecurityContextToken(idURI, null, wsuId);
        }
        if (wsscEleFac instanceof WSSCElementFactory13) {
            return ((WSSCElementFactory13)wsscEleFac).createSecurityContextToken(idURI, null, wsuId);
        }
        return null;
    }

    public static SecurityContextToken createSecurityContextToken(WSSCElementFactory eleFac) throws WSSecureConversationException {
        URI idURI;
        String identifier = "urn:uuid:" + UUID.randomUUID().toString();
        try {
            idURI = new URI(identifier);
        }
        catch (URISyntaxException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
        String wsuId = "uuid-" + UUID.randomUUID().toString();
        return eleFac.createSecurityContextToken(idURI, null, wsuId);
    }

    public static SecurityContextToken createSecurityContextToken(WSTrustElementFactory wsscEleFac, String identifier) throws WSSecureConversationException {
        URI idURI;
        try {
            idURI = new URI(identifier);
        }
        catch (URISyntaxException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
        String wsuId = "uuid-" + UUID.randomUUID().toString();
        String wsuInstance = "uuid-" + UUID.randomUUID().toString();
        if (wsscEleFac instanceof WSSCElementFactory) {
            return ((WSSCElementFactory)wsscEleFac).createSecurityContextToken(idURI, wsuInstance, wsuId);
        }
        if (wsscEleFac instanceof WSSCElementFactory13) {
            return ((WSSCElementFactory13)wsscEleFac).createSecurityContextToken(idURI, wsuInstance, wsuId);
        }
        return null;
    }

    public static SecurityContextToken createSecurityContextToken(WSSCElementFactory eleFac, String identifier) throws WSSecureConversationException {
        URI idURI;
        try {
            idURI = new URI(identifier);
        }
        catch (URISyntaxException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
        String wsuId = "uuid-" + UUID.randomUUID().toString();
        String wsuInstance = "uuid-" + UUID.randomUUID().toString();
        return eleFac.createSecurityContextToken(idURI, wsuInstance, wsuId);
    }

    public static SecurityTokenReference createSecurityTokenReference(String id, String valueType) {
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance();
        KeyIdentifier ref = eleFac.createKeyIdentifier(valueType, null);
        ref.setValue(id);
        return eleFac.createSecurityTokenReference(ref);
    }

    public static AppliesTo createAppliesTo(String appliesTo) {
        AttributedURI uri = new AttributedURI();
        uri.setValue(appliesTo);
        EndpointReference epr = new EndpointReference();
        epr.setAddress(uri);
        AppliesTo applTo = new ObjectFactory().createAppliesTo();
        applTo.getAny().add(new com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory().createEndpointReference(epr));
        return applTo;
    }

    public static List<Object> parseAppliesTo(AppliesTo appliesTo) {
        List<Object> list = appliesTo.getAny();
        EndpointReference epr = null;
        ArrayList<Object> result = new ArrayList<Object>();
        if (!list.isEmpty()) {
            for (Object obj : list) {
                JAXBElement ele;
                String local;
                if (obj instanceof EndpointReference) {
                    epr = (EndpointReference)obj;
                } else if (obj instanceof JAXBElement && (local = (ele = (JAXBElement)obj).getName().getLocalPart()).equalsIgnoreCase("EndpointReference")) {
                    epr = (EndpointReference)ele.getValue();
                }
                if (epr == null) continue;
                AttributedURI uri = epr.getAddress();
                if (uri != null) {
                    result.add(uri.getValue());
                }
                for (Object obj2 : epr.getAny()) {
                    try {
                        NodeList nodeList;
                        Element ele2 = WSTrustElementFactory.newInstance().toElement(obj2);
                        if (ele2 == null || (nodeList = ele2.getElementsByTagNameNS("*", "Identity")).getLength() <= 0) continue;
                        Element identity = (Element)nodeList.item(0);
                        result.add(identity);
                        NodeList clist = identity.getChildNodes();
                        for (int i = 0; i < clist.getLength(); ++i) {
                            if (clist.item(i).getNodeType() != 3) continue;
                            String data = ((Text)clist.item(i)).getData();
                            X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.decode(data)));
                            result.add(cert);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static String getAppliesToURI(AppliesTo appliesTo) {
        List<Object> list = appliesTo.getAny();
        EndpointReference epr = null;
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                AttributedURI uri;
                JAXBElement ele;
                String local;
                Object obj = list.get(i);
                if (obj instanceof EndpointReference) {
                    epr = (EndpointReference)obj;
                } else if (obj instanceof JAXBElement && (local = (ele = (JAXBElement)obj).getName().getLocalPart()).equalsIgnoreCase("EndpointReference")) {
                    epr = (EndpointReference)ele.getValue();
                }
                if (epr == null || (uri = epr.getAddress()) == null) continue;
                return uri.getValue();
            }
        }
        return null;
    }

    public static String createFriendlyPPID(String displayValue) {
        return displayValue;
    }

    public static String elemToString(BaseSTSResponse rstr, WSTrustVersion wstVer) {
        StringWriter writer = new StringWriter();
        try {
            Transformer trans = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newTransformer();
            trans.transform(WSTrustElementFactory.newInstance(wstVer).toSource(rstr), new StreamResult(writer));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static String elemToString(BaseSTSRequest rst, WSTrustVersion wstVer) {
        StringWriter writer = new StringWriter();
        try {
            Transformer trans = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newTransformer();
            trans.transform(WSTrustElementFactory.newInstance(wstVer).toSource(rst), new StreamResult(writer));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static long getCurrentTimeWithOffset() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        long beforeTime = cal.getTimeInMillis();
        return beforeTime - (long)offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lifetime createLifetime(long currentTime, long lifespan, WSTrustVersion wstVer) {
        SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(((Calendar)cal).getTimeZone());
            cal.setTimeInMillis(currentTime);
            AttributedDateTime created = new AttributedDateTime();
            created.setValue(calendarFormatter.format(cal.getTime()));
            AttributedDateTime expires = new AttributedDateTime();
            cal.setTimeInMillis(currentTime + lifespan);
            expires.setValue(calendarFormatter.format(cal.getTime()));
            Lifetime lifetime = WSTrustElementFactory.newInstance(wstVer).createLifetime(created, expires);
            return lifetime;
        }
    }

    public static long getLifeSpan(Lifetime lifetime) {
        AttributedDateTime created = lifetime.getCreated();
        AttributedDateTime expires = lifetime.getExpires();
        return WSTrustUtil.parseAttributedDateTime(expires).getTime() - WSTrustUtil.parseAttributedDateTime(created).getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseAttributedDateTime(AttributedDateTime time) {
        SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
        Date date = null;
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            try {
                date = calendarFormatter.parse(time.getValue());
            }
            catch (Exception ex) {
                try {
                    SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());
                    date = calendarFormatter1.parse(time.getValue());
                }
                catch (ParseException pex) {
                    throw new RuntimeException(pex);
                }
            }
        }
        return date;
    }

    public static EncryptedKey encryptKey(Document doc, byte[] encryptedKey, X509Certificate cert, String keyWrapAlgorithm) throws Exception {
        PublicKey pubKey = cert.getPublicKey();
        XMLCipher cipher = keyWrapAlgorithm != null ? XMLCipher.getInstance((String)keyWrapAlgorithm) : XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        cipher.init(3, (Key)pubKey);
        EncryptedKey encKey = cipher.encryptKey(doc, (Key)new SecretKeySpec(encryptedKey, "AES"));
        KeyInfo keyinfo = new KeyInfo(doc);
        byte[] skid = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(cert);
        if (skid != null && skid.length > 0) {
            KeyIdentifierImpl keyIdentifier = new KeyIdentifierImpl("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", null);
            keyIdentifier.setValue(Base64.encode(skid));
            SecurityTokenReferenceImpl str = new SecurityTokenReferenceImpl(keyIdentifier);
            keyinfo.addUnknownElement((Element)doc.importNode(WSTrustElementFactory.newInstance().toElement(str, null), true));
        } else {
            X509Data x509data = new X509Data(doc);
            x509data.addCertificate(cert);
            keyinfo.add(x509data);
        }
        encKey.setKeyInfo(keyinfo);
        return encKey;
    }

    public static Assertion addSamlAttributes(Assertion assertion, Map<QName, List<String>> claimedAttrs) throws WSTrustException {
        try {
            String version = assertion.getVersion();
            SAMLAssertionFactory samlFac = null;
            samlFac = "2.0".equals(version) ? SAMLAssertionFactory.newInstance("Saml2.0") : SAMLAssertionFactory.newInstance("Saml1.1");
            Element assertionEle = assertion.toElement(null);
            String samlNS = assertionEle.getNamespaceURI();
            String samlPrefix = assertionEle.getPrefix();
            NodeList asList = assertionEle.getElementsByTagNameNS(samlNS, "AttributeStatement");
            Node as = null;
            if (asList.getLength() > 0) {
                as = asList.item(0);
            }
            WSTrustUtil.createAttributeStatement(as, claimedAttrs, samlNS, samlPrefix);
            return samlFac.createAssertion(assertionEle);
        }
        catch (Exception ex) {
            throw new WSTrustException(ex.getMessage());
        }
    }

    private static Node createAttributeStatement(Node as, Map<QName, List<String>> claimedAttrs, String samlNS, String samlPrefix) throws WSTrustException {
        try {
            Document doc = null;
            if (as != null) {
                doc = as.getOwnerDocument();
            } else {
                doc = WSTrustUtil.newDocument();
                as = doc.createElementNS(samlNS, samlPrefix + ":AttributeStatement");
                doc.appendChild(as);
            }
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values.size() <= 0) continue;
                Element attrEle = null;
                if ("NameID".equals(attrKey.getLocalPart())) {
                    attrEle = WSTrustUtil.createActorAttribute(doc, samlNS, samlPrefix, values.get(0));
                } else {
                    attrEle = WSTrustUtil.createAttribute(doc, samlNS, samlPrefix, attrKey);
                    Iterator<String> valueIt = values.iterator();
                    while (valueIt.hasNext()) {
                        Element attrValueEle = doc.createElementNS(samlNS, samlPrefix + ":AttributeValue");
                        Text text = doc.createTextNode(valueIt.next());
                        attrValueEle.appendChild(text);
                        attrEle.appendChild(attrValueEle);
                    }
                }
                as.appendChild(attrEle);
            }
            return as;
        }
        catch (Exception ex) {
            throw new WSTrustException(ex.getMessage());
        }
    }

    private static Element createAttribute(Document doc, String samlNS, String samlPrefix, QName attrKey) throws Exception {
        Element attrEle = doc.createElementNS(samlNS, samlPrefix + ":Attribute");
        attrEle.setAttribute("AttributeName", attrKey.getLocalPart());
        attrEle.setAttribute("AttributeNamespace", attrKey.getNamespaceURI());
        if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(samlNS)) {
            attrEle.setAttribute("Name", attrKey.getLocalPart());
            attrEle.setAttribute("NameFormat", attrKey.getNamespaceURI());
        }
        return attrEle;
    }

    private static Element createActorAttribute(Document doc, String samlNS, String samlPrefix, String name) throws Exception {
        Element actorEle = WSTrustUtil.createAttribute(doc, samlNS, samlPrefix, new QName("actor", "http://schemas.xmlsoap.com/ws/2009/09/identity/claims"));
        Element attrValueEle = doc.createElementNS(samlNS, samlPrefix + ":AttributeValue");
        actorEle.appendChild(attrValueEle);
        Element nameEle = WSTrustUtil.createAttribute(doc, samlNS, samlPrefix, new QName("name", "http://schemas.xmlsoap.com/ws/2005/05/identity/claims"));
        attrValueEle.appendChild(nameEle);
        Element nameAttrValueEle = doc.createElementNS(samlNS, samlPrefix + ":AttributeValue");
        nameEle.appendChild(nameAttrValueEle);
        Text text = doc.createTextNode(name);
        nameAttrValueEle.appendChild(text);
        return actorEle;
    }

    public static Document newDocument() {
        Document doc;
        try {
            DocumentBuilderFactory dbf = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return doc;
    }
}

