/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.util.Pool;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public final class FiberExecutor {
    private Pool<Tube> tubelinePool;
    private volatile Engine engine;
    private final List<Schedule> schedules = new LinkedList<Schedule>();
    private Executor executor;

    public FiberExecutor(String id, Tube masterTubeline) {
        this.tubelinePool = new Pool.TubePool(masterTubeline);
        this.executor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.engine = new Engine(id, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet runSync(Packet request) {
        Tube tubeline = (Tube)this.tubelinePool.take();
        try {
            Packet packet = this.engine.createFiber().runSync(tubeline, request);
            return packet;
        }
        finally {
            this.tubelinePool.recycle((Object)tubeline);
        }
    }

    public synchronized void schedule(Packet request, @NotNull Fiber.CompletionCallback callback) {
        this.schedules.add(new Schedule(request, callback));
    }

    public synchronized void startScheduledFibers() {
        Iterator<Schedule> iterator = this.schedules.iterator();
        while (iterator.hasNext()) {
            Schedule schedule = iterator.next();
            iterator.remove();
            this.start(schedule.request, schedule.completionCallback, null);
        }
    }

    public void start(Packet request, final @NotNull Fiber.CompletionCallback callback, @Nullable FiberContextSwitchInterceptor interceptor) {
        Fiber fiber = this.engine.createFiber();
        if (interceptor != null) {
            fiber.addInterceptor(interceptor);
        }
        final Tube tube = (Tube)this.tubelinePool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet response) {
                FiberExecutor.this.tubelinePool.recycle((Object)tube);
                callback.onCompletion(response);
            }

            public void onCompletion(@NotNull Throwable error) {
                callback.onCompletion(error);
            }
        });
    }

    public void close() {
        Executor fes;
        Pool<Tube> tp = this.tubelinePool;
        if (tp != null) {
            Tube p = (Tube)tp.take();
            p.preDestroy();
            this.tubelinePool = null;
            this.engine = null;
            this.schedules.clear();
        }
        if ((fes = this.executor) != null) {
            this.executor = null;
        }
    }

    private static class Schedule {
        private final Packet request;
        private final Fiber.CompletionCallback completionCallback;

        public Schedule(Packet request, Fiber.CompletionCallback completionCallback) {
            this.request = request;
            this.completionCallback = completionCallback;
        }
    }
}

