/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rx.util.ResumeFiberException;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import java.util.logging.Level;

public class SuspendedFiberStorage
extends TimestampedCollection<String, Fiber> {
    private static final Logger LOGGER = Logger.getLogger(SuspendedFiberStorage.class);

    @Override
    public Fiber register(String correlationId, Fiber subject) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Registering fiber [ %s ] with correlationId [ %s ] for suspend", subject.toString(), correlationId));
        }
        return super.register(correlationId, subject);
    }

    @Override
    public boolean register(long timestamp, Fiber subject) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Registering fiber [ %s ] with timestamp [ %d ] for suspend", subject.toString(), timestamp));
        }
        return super.register(timestamp, subject);
    }

    public void resumeFiber(String correlationId, Packet response) throws ResumeFiberException {
        Fiber fiber = (Fiber)this.remove(correlationId);
        if (fiber == null) {
            throw (ResumeFiberException)((Object)LOGGER.logSevereException((Throwable)((Object)new ResumeFiberException(String.format("Unable to resume fiber with a response packet: No registered fiber found for correlationId [ %s ].", correlationId)))));
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Resuming fiber [ %s ] with a response", fiber.toString()));
        }
        fiber.resume(response);
    }

    public void resumeFiber(String correlationId, Throwable error) throws ResumeFiberException {
        Fiber fiber = (Fiber)this.remove(correlationId);
        if (fiber == null) {
            throw (ResumeFiberException)((Object)LOGGER.logSevereException((Throwable)((Object)new ResumeFiberException(String.format("Unable to resume fiber with a response packet: No registered fiber found for correlationId [ %s ].", correlationId)))));
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning(String.format("Resuming fiber [ %s ] with an exception", fiber.toString()));
        }
        fiber.resume(error);
    }

    public void resumeAllFibers(Throwable error) {
        for (Fiber fiber : this.removeAll()) {
            fiber.resume(error);
        }
    }
}

