/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.tokens;

import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.tokens.Timestamp;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.AttributedString;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.UsernameTokenType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;

public class UsernameToken
extends UsernameTokenType
implements com.sun.xml.ws.security.opt.api.tokens.UsernameToken,
SecurityHeaderElement,
SecurityElementWriter {
    public static final long MAX_NONCE_AGE = 900000L;
    private String passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private String usernameValue = null;
    private String passwordValue = null;
    private String passwordDigestValue = null;
    private byte[] decodedNonce = null;
    private String nonceValue = null;
    private String nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private String createdValue = null;
    private boolean bsp = false;
    private boolean valuesSet = false;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private ObjectFactory objFac = new ObjectFactory();
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public UsernameToken(SOAPVersion sv) {
        this.soapVersion = sv;
    }

    public String getUsernameValue() {
        return this.usernameValue;
    }

    public void setUsernameValue(String username) {
        this.usernameValue = username;
    }

    public String getPasswordValue() {
        return this.passwordValue;
    }

    public void setPasswordValue(String passwd) {
        this.passwordValue = passwd;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    private void setPasswordType(String passwordType) throws SecurityTokenException {
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(passwordType)) {
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(passwordType)) {
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0306_INVALID_PASSWD_TYPE("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest"), new Object[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest"});
            throw new SecurityTokenException("Invalid password type. Must be one of   http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText or http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        }
    }

    public String getNonceEncodingType() {
        return this.nonceEncodingType;
    }

    private void setNonceEncodingType(String nonceEncodingType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(nonceEncodingType)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0307_NONCE_ENCTYPE_INVALID());
            throw new RuntimeException("Nonce encoding type invalid");
        }
        this.nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }

    public String getNonceValue() throws SecurityTokenException {
        return this.nonceValue;
    }

    public String getCreatedValue() {
        return this.createdValue;
    }

    public String getPasswordDigestValue() {
        return this.passwordDigestValue;
    }

    public void setNonce(String nonceValue) {
        if (nonceValue == null || "".equals(nonceValue)) {
            this.createNonce();
        } else {
            this.nonceValue = nonceValue;
        }
    }

    public void setCreationTime(String time) throws XWSSecurityException {
        this.createdValue = time == null || "".equals(time) ? this.getCreatedFromTimestamp() : time;
    }

    public void setDigestOn() throws SecurityTokenException {
        this.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    public boolean isBSP() {
        return this.bsp;
    }

    public String getNamespaceURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    public String getLocalPart() {
        return "UsernameToken";
    }

    public String getAttribute(String nsUri, String localName) {
        QName qname = new QName(nsUri, localName);
        Map otherAttributes = this.getOtherAttributes();
        return (String)otherAttributes.get(qname);
    }

    public String getAttribute(QName name) {
        Map otherAttributes = this.getOtherAttributes();
        return (String)otherAttributes.get(name);
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        if (!this.valuesSet) {
            this.setValues();
        }
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement utElem = this.objFac.createUsernameToken((UsernameTokenType)this);
        try {
            this.getMarshaller().marshal((Object)utElem, (Result)xbr);
        }
        catch (JAXBException je) {
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    public void writeTo(OutputStream os) {
        if (!this.valuesSet) {
            this.setValues();
        }
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (!this.valuesSet) {
            this.setValues();
        }
        JAXBElement utElem = this.objFac.createUsernameToken((UsernameTokenType)this);
        try {
            OutputStream os;
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.getMarshaller().marshal((Object)utElem, os);
                return;
            }
            this.getMarshaller().marshal((Object)utElem, streamWriter);
        }
        catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    private void createNonce() {
        this.decodedNonce = new byte[18];
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.decodedNonce);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0310_NO_SUCH_ALGORITHM(e.getMessage()), new Object[]{e.getMessage()});
            throw new RuntimeException("No such algorithm found" + e.getMessage());
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary" != this.nonceEncodingType) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0389_UNRECOGNIZED_NONCE_ENCODING(this.nonceEncodingType), this.nonceEncodingType);
            throw new RuntimeException("Unrecognized encoding: " + this.nonceEncodingType);
        }
        this.nonceValue = Base64.encode(this.decodedNonce);
    }

    private String getCreatedFromTimestamp() throws XWSSecurityException {
        Timestamp ts = new Timestamp(this.soapVersion);
        ts.createDateTime();
        return ts.getCreated().getValue();
    }

    private void createDigest() throws SecurityTokenException {
        byte[] hash;
        byte[] bytesToHash;
        byte[] utf8Bytes;
        String utf8String = "";
        if (this.createdValue != null) {
            utf8String = utf8String + this.createdValue;
        }
        if (this.passwordValue != null) {
            utf8String = utf8String + this.passwordValue;
        }
        try {
            utf8Bytes = utf8String.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0390_UNSUPPORTED_CHARSET_EXCEPTION());
            throw new SecurityTokenException(uee);
        }
        if (this.decodedNonce != null) {
            int i;
            bytesToHash = new byte[utf8Bytes.length + this.decodedNonce.length];
            for (i = 0; i < this.decodedNonce.length; ++i) {
                bytesToHash[i] = this.decodedNonce[i];
            }
            for (i = this.decodedNonce.length; i < utf8Bytes.length + this.decodedNonce.length; ++i) {
                bytesToHash[i] = utf8Bytes[i - this.decodedNonce.length];
            }
        } else {
            bytesToHash = utf8Bytes;
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            hash = sha.digest(bytesToHash);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0311_PASSWD_DIGEST_COULDNOT_BE_CREATED(e.getMessage()), new Object[]{e.getMessage()});
            throw new SecurityTokenException("Password Digest could not be created. " + e.getMessage());
        }
        this.passwordDigestValue = Base64.encode(hash);
    }

    private void setValues() {
        QName qname;
        if (this.usernameValue != null) {
            AttributedString ut = this.objFac.createAttributedString();
            ut.setValue(this.usernameValue);
            this.setUsername(ut);
        }
        if (this.passwordValue != null && !MessageConstants._EMPTY.equals(this.passwordValue)) {
            AttributedString pw = this.objFac.createAttributedString();
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest" == this.passwordType) {
                try {
                    this.createDigest();
                }
                catch (SecurityTokenException ex) {
                    ex.printStackTrace();
                }
                pw.setValue(this.passwordDigestValue);
                this.setPassword(pw);
            } else {
                pw.setValue(this.passwordValue);
                this.setPassword(pw);
            }
            qname = new QName("Type");
            pw.getOtherAttributes().put(qname, this.passwordType);
        }
        if (this.nonceValue != null) {
            AttributedString non = this.objFac.createAttributedString();
            non.setValue(this.nonceValue);
            this.setNonce(non);
            if (this.nonceEncodingType != null) {
                qname = new QName("EncodingType");
                non.getOtherAttributes().put(qname, this.nonceEncodingType);
            }
        }
        if (this.createdValue != null) {
            AttributedString cr = this.objFac.createAttributedString();
            cr.setValue(this.createdValue);
            this.setCreated(cr);
        }
        this.valuesSet = true;
    }

    public boolean refersToSecHdrWithId(String id) {
        return false;
    }

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            OutputStream os;
            if (!this.valuesSet) {
                this.setValues();
            }
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            JAXBElement utElem = this.objFac.createUsernameToken((UsernameTokenType)this);
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                marshaller.marshal((Object)utElem, os);
                return;
            }
            marshaller.marshal((Object)utElem, streamWriter);
        }
        catch (JAXBException jbe) {
            throw new XMLStreamException(jbe);
        }
    }
}

