/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceListHeaderBlock
extends SecurityHeaderBlockImpl {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Document ownerDoc;
    private int size = 0;

    public ReferenceListHeaderBlock() throws XWSSecurityException {
        try {
            this.setSOAPElement(ReferenceListHeaderBlock.getSoapFactory().createElement("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            this.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0360.error.creating.rlhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.ownerDoc = this.getAsSoapElement().getOwnerDocument();
    }

    public ReferenceListHeaderBlock(Document doc) throws XWSSecurityException {
        try {
            this.setSOAPElement((SOAPElement)doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList"));
            this.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0361.error.creating.rlhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.ownerDoc = doc;
    }

    public ReferenceListHeaderBlock(SOAPElement element) throws XWSSecurityException {
        super(element);
        if (!element.getLocalName().equals("ReferenceList") || !XMLUtil.inEncryptionNS(element)) {
            log.log(Level.SEVERE, "WSS0362.error.creating.rlhb", element.getTagName());
            throw new XWSSecurityException("Invalid ReferenceList passed");
        }
        this.ownerDoc = element.getOwnerDocument();
        this.size = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").getLength();
    }

    public int size() {
        return this.size;
    }

    public void addReference(String referenceURI) throws XWSSecurityException {
        try {
            Element dataRefElement = this.ownerDoc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataRefElement.setAttribute("URI", referenceURI);
            XMLUtil.prependChildElement((Element)((Object)this), dataRefElement, false, this.ownerDoc);
            ++this.size;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0363.error.adding.datareference", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public Iterator getReferences() {
        Vector<String> references = new Vector<String>();
        Iterator eachChild = this.getChildElements();
        while (eachChild.hasNext()) {
            SOAPElement element;
            Node object = (Node)eachChild.next();
            if (object.getNodeType() != 1 || !(element = (SOAPElement)object).getLocalName().equals("DataReference") || !XMLUtil.inEncryptionNS(element)) continue;
            references.addElement(element.getAttribute("URI"));
        }
        return references.iterator();
    }

    public NodeList getDataRefElements() {
        return this.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, ReferenceListHeaderBlock.class);
    }
}

