/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol")
@PerLookup
@I18n(value="delete.protocol")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteProtocol
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProtocol.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    Protocol protocol = null;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            this.protocol = protocols.findProtocol(this.protocolName);
            if (this.protocol == null) {
                report.setMessage(localStrings.getLocalString("delete.protocol.notexists", "{0} protocol doesn't exist", new Object[]{this.protocolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List nwlsnrList = this.protocol.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.protocol.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(localStrings.getLocalString("delete.protocol.beingused", "{0} protocol is being used in the network listener {1}", new Object[]{this.protocolName, nwlsnr.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) {
                    param.getProtocol().remove(DeleteProtocol.this.protocol);
                    return DeleteProtocol.this.protocol;
                }
            }, (ConfigBeanProxy)protocols);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.protocol.fail", "Deletion of Protocol {0} failed", new Object[]{this.protocolName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

