/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol-finder")
@Scoped(value=PerLookup.class)
@I18n(value="delete.protocol.finder")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.DELETE, path="delete-protocol-finder", description="Delete", params={@RestParam(name="protocol", value="$parent")})})
public class DeleteProtocolFinder
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProtocolFinder.class);
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Services services;
    private ActionReport report;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.byType(Target.class).get();
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.report = context.getActionReport();
        try {
            Protocols protocols = this.config.getNetworkConfig().getProtocols();
            Protocol protocol = protocols.findProtocol(this.protocolName);
            this.validate((ConfigBeanProxy)protocol, "create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.protocolName);
            PortUnification pu = this.getPortUnification(protocol);
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) {
                    Protocol prot = (Protocol)params[0];
                    PortUnification portUnification = (PortUnification)params[1];
                    List oldList = portUnification.getProtocolFinder();
                    ArrayList<ProtocolFinder> newList = new ArrayList<ProtocolFinder>();
                    for (ProtocolFinder finder : oldList) {
                        if (DeleteProtocolFinder.this.name.equals(finder.getName())) continue;
                        newList.add(finder);
                    }
                    if (oldList.size() == newList.size()) {
                        throw new RuntimeException(String.format("No finder named %s found for protocol %s", DeleteProtocolFinder.this.name, DeleteProtocolFinder.this.protocolName));
                    }
                    if (newList.isEmpty()) {
                        prot.setPortUnification(null);
                    } else {
                        portUnification.setProtocolFinder(newList);
                    }
                    return null;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{protocol, pu});
            this.cleanPortUnification(pu);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(localStrings.getLocalString("delete.fail", "{0} delete failed: {1}", new Object[]{this.name, e.getMessage() == null ? "No reason given" : e.getMessage()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
            return;
        }
    }

    private PortUnification getPortUnification(Protocol protocol) {
        PortUnification pu = protocol.getPortUnification();
        if (pu == null) {
            this.report.setMessage(localStrings.getLocalString("not.found", "No {0} element found for {1}", new Object[]{"port-unification", protocol.getName()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return pu;
    }

    private void cleanPortUnification(PortUnification pu) throws TransactionFailure {
        if (pu != null && pu.getProtocolFinder().isEmpty()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) {
                    param.setPortUnification(null);
                    return null;
                }
            }, (ConfigBeanProxy)pu.getParent(Protocol.class));
        }
    }

    private void validate(ConfigBeanProxy check, String key, String defaultFormat, String ... arguments) throws ValidationFailureException {
        if (check == null) {
            this.report.setMessage(localStrings.getLocalString(key, defaultFormat, (Object[])arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private static class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

