/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.DELETE, path="delete-http", description="Delete", params={@RestParam(name="protocol", value="$parent")})})
public class DeleteHttp
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    Protocol protocolToBeRemoved = null;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Services services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.byType(Target.class).get();
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            for (Protocol protocol : protocols.getProtocol()) {
                if (!this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
                this.protocolToBeRemoved = protocol;
            }
            if (this.protocolToBeRemoved == null) {
                report.setMessage(localStrings.getLocalString("delete.http.notexists", "{0} http-redirect doesn't exist", new Object[]{this.protocolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List nwlsnrList = this.protocolToBeRemoved.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.protocolToBeRemoved.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(localStrings.getLocalString("delete.protocol.beingused", "{0} protocol is being used in the network listener {1}", new Object[]{this.protocolName, nwlsnr.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) {
                    param.setHttp(null);
                    return null;
                }
            }, (ConfigBeanProxy)this.protocolToBeRemoved);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.redirect.fail", "Deletion of http-redirect {0} failed", new Object[]{this.protocolName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

