/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.Collator;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public abstract class MappingElementImpl
implements MappingElement {
    private static final ResourceBundle _messages = I18NHelper.loadBundle((String)"com.sun.jdo.api.persistence.model.Bundle", (ClassLoader)MappingElementImpl.class.getClassLoader());
    private PropertyChangeSupport _support;
    private transient VetoableChangeSupport _vetoableSupport;
    String _name;

    public MappingElementImpl() {
        this(null);
    }

    public MappingElementImpl(String name) {
        this._name = name;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        if (this._support != null) {
            this._support.firePropertyChange(name, o, n);
        }
    }

    protected void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.fireVetoableChange(name, o, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            MappingElementImpl mappingElementImpl = this;
            synchronized (mappingElementImpl) {
                if (this._support == null) {
                    this._support = new PropertyChangeSupport(this);
                }
            }
        }
        this._support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    @Override
    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoableSupport == null) {
            this._vetoableSupport = new VetoableChangeSupport(this);
        }
        this._vetoableSupport.addVetoableChangeListener(l);
    }

    @Override
    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.removeVetoableChangeListener(l);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) throws ModelException {
        String old = this.getName();
        try {
            this.fireVetoableChange("name", old, name);
            this._name = name;
            this.firePropertyChange("name", old, name);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new ClassCastException();
        }
        if (o == this) {
            return 0;
        }
        String thisName = this.getName();
        String otherName = ((MappingElementImpl)o).getName();
        if (thisName == null) {
            return otherName == null ? 0 : -1;
        }
        if (otherName == null) {
            return 1;
        }
        int ret = Collator.getInstance().compare(thisName, otherName);
        if (ret == 0 && this.getClass() != o.getClass()) {
            ret = this.getClass().getName().compareTo(o.getClass().getName());
        }
        return ret;
    }
}

