/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class MappingFieldElementImpl
extends MappingMemberElementImpl
implements MappingFieldElement {
    private ArrayList _columns;
    private transient ArrayList _columnObjects;
    private int _fetchGroup;
    private int _properties;
    private boolean _isVersion;
    public static final int CLONE_FIELD = 1;
    public static final int CLONE_DEEP = 2;
    public static final int CLONE_MASK = 3;
    public static final int LOG_ON_ACCESS = 4;
    public static final int LOG_ON_MASK = 48;
    public static final int LOG_ON_UPDATE = 16;
    public static final int MOD_BI_ON_UPDATE = 32;
    public static final int OBSERVE_ON_ACCESS = 8;
    public static final int RECORD_ON_UPDATE = 64;
    public static final int SEND_BEFORE_IMAGE = 128;
    public static final int READ_ONLY = 256;
    public static final int REF_INTEGRITY_UPDATES = 512;
    public static final int IN_CONCURRENCY_CHECK = 1024;
    public static final int XLATE_FIELD = 2048;

    public MappingFieldElementImpl() {
        this(null, null);
    }

    public MappingFieldElementImpl(String name, MappingClassElement declaringClass) {
        super(name, declaringClass);
        this.setFetchGroupInternal(1);
    }

    public boolean isReadOnly() {
        return this.getProperty(256);
    }

    public void setReadOnly(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf((boolean)this.isReadOnly());
        Boolean newFlag = JavaTypeHelper.valueOf((boolean)flag);
        try {
            this.fireVetoableChange("readOnly", old, newFlag);
            this.setProperty(flag, 256);
            this.firePropertyChange("readOnly", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public boolean isInConcurrencyCheck() {
        return this.getProperty(1024);
    }

    public void setInConcurrencyCheck(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf((boolean)this.isInConcurrencyCheck());
        Boolean newFlag = JavaTypeHelper.valueOf((boolean)flag);
        try {
            this.fireVetoableChange("inConcurrencyCheck", old, newFlag);
            this.setProperty(flag, 1024);
            this.firePropertyChange("inConcurrencyCheck", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public boolean isVersion() {
        return this._isVersion;
    }

    public void setVersion(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf((boolean)this.isVersion());
        Boolean newFlag = JavaTypeHelper.valueOf((boolean)flag);
        try {
            this.fireVetoableChange("versionField", old, newFlag);
            this._isVersion = flag;
            this.firePropertyChange("versionField", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public int getFetchGroup() {
        return this._fetchGroup;
    }

    public void setFetchGroup(int group) throws ModelException {
        Integer old = new Integer(this.getFetchGroup());
        Integer newGroup = new Integer(group);
        try {
            this.fireVetoableChange("fetchGroup", old, newGroup);
            this.setFetchGroupInternal(group);
            this.firePropertyChange("fetchGroup", old, newGroup);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    protected void setFetchGroupInternal(int group) {
        this._fetchGroup = group;
    }

    public ArrayList getColumns() {
        if (this._columns == null) {
            this._columns = new ArrayList();
        }
        return this._columns;
    }

    public void addColumn(DBMemberElement column) throws ModelException {
        if (column != null) {
            String columnName;
            ArrayList columns = this.getColumns();
            if (!columns.contains(columnName = NameUtil.getRelativeMemberName((String)column.getName().getFullName()))) {
                try {
                    this.fireVetoableChange("columns", null, null);
                    columns.add(columnName);
                    this.firePropertyChange("columns", null, null);
                    this._columnObjects = null;
                }
                catch (PropertyVetoException e) {
                    throw new ModelVetoException(e);
                }
            }
        } else {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingFieldElementImpl.getMessages(), (String)"mapping.element.null_argument"));
        }
    }

    public void removeColumn(String columnName) throws ModelException {
        if (columnName != null) {
            try {
                this.fireVetoableChange("columns", null, null);
                if (!this.getColumns().remove(columnName)) {
                    throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingFieldElementImpl.getMessages(), (String)"mapping.element.element_not_removed", (String)columnName));
                }
                this.firePropertyChange("columns", null, null);
                this._columnObjects = null;
            }
            catch (PropertyVetoException e) {
                throw new ModelVetoException(e);
            }
        }
    }

    protected boolean isMappedToTable(MappingTableElement table) {
        String tableName = table.getName();
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            String columnName = iterator.next().toString();
            if (!NameUtil.getTableName((String)columnName).equals(tableName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getColumnObjects() {
        if (this._columnObjects == null) {
            this._columnObjects = MappingClassElementImpl.toColumnObjects(this.getDeclaringClass().getDatabaseRoot(), this.getColumns());
        }
        return this._columnObjects;
    }

    final PersistenceFieldElement getPersistenceFieldElement() {
        return ((MappingClassElementImpl)this.getDeclaringClass()).getPersistenceElement().getField(this.getName());
    }

    public int getFieldNumber() {
        return this.getPersistenceFieldElement().getFieldNumber();
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return this.getPersistenceFieldElement().getConcurrencyGroups();
    }

    private boolean getProperty(int propertyBit) {
        return (this.getProperties() & propertyBit) > 0;
    }

    public void setProperty(boolean flag, int propertyBit) {
        this._properties = flag ? this._properties | propertyBit : this._properties & ~propertyBit;
    }

    public int getProperties() {
        return this._properties;
    }

    public boolean getLogOnAccess() {
        return this.getProperty(4);
    }

    public void setLogOnAccess(boolean flag) {
        this.setProperty(flag, 4);
    }

    public boolean getLogOnUpdate() {
        return this.getProperty(16);
    }

    public void setLogOnUpdate(boolean flag) {
        this.setProperty(flag, 16);
    }

    public boolean getObserveOnAccess() {
        return this.getProperty(8);
    }

    public void setObserveOnAccess(boolean flag) {
        this.setProperty(flag, 8);
    }

    public boolean getRecordOnUpdate() {
        return this.getProperty(64);
    }

    public void setRecordOnUpdate(boolean flag) {
        this.setProperty(flag, 64);
    }

    public boolean getModifyBeforeImageOnUpdate() {
        return this.getProperty(32);
    }

    public void setModifyBeforeImageOnUpdate(boolean flag) {
        this.setProperty(flag, 32);
    }

    public boolean getReferentialIntegrityUpdates() {
        return this.getProperty(512);
    }

    public void setReferentialIntegrityUpdates(boolean flag) {
        this.setProperty(flag, 512);
    }

    public boolean getSendBeforeImage() {
        return this.getProperty(128);
    }

    public void setSendBeforeImage(boolean flag) {
        this.setProperty(flag, 128);
    }

    public int getCloneDepth() {
        return this._properties & 3;
    }

    public void setCloneDepth(int cloneDepth) {
        if (cloneDepth < 1 || cloneDepth > 2) {
            // empty if block
        }
        this._properties = this._properties & 0xFFFFFFFC | cloneDepth;
    }

    protected void stripSchemaName() {
        if (this._columns != null) {
            ListIterator<String> i = this._columns.listIterator();
            while (i.hasNext()) {
                i.set(NameUtil.getRelativeMemberName((String)((String)i.next())));
            }
        }
    }
}

