/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.PersistenceCapable;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import java.util.Collection;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class JDOHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", (ClassLoader)JDOHelper.class.getClassLoader());
    static final String null_instance = "null";

    public static PersistenceManager getPersistenceManager(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoGetPersistenceManager();
        }
        return null;
    }

    public static void makeDirty(Object obj, String fieldName) {
        if (obj instanceof PersistenceCapable) {
            ((PersistenceCapable)obj).jdoMakeDirty(fieldName);
        }
    }

    public static Object getObjectId(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoGetObjectId();
        }
        return null;
    }

    public static boolean isDirty(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsDirty();
        }
        return false;
    }

    public static boolean isTransactional(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsTransactional();
        }
        return false;
    }

    public static boolean isPersistent(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsPersistent();
        }
        return false;
    }

    public static boolean isNew(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsNew();
        }
        return false;
    }

    public static boolean isDeleted(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsDeleted();
        }
        return false;
    }

    public static String printObject(Object o) {
        if (o == null) {
            return null_instance;
        }
        if (JDOHelper.isDeleted(o)) {
            return I18NHelper.getMessage((ResourceBundle)messages, (String)"jdohelper.deleted_instance", (String)o.getClass().getName());
        }
        return o.toString();
    }

    private static ClassLoader getObjectClassLoader(Object obj) {
        Class<?> clazz = obj.getClass();
        if (obj instanceof Collection) {
            return JDOHelper.getCollectionClassLoader((Collection)obj);
        }
        if (clazz.isArray()) {
            return JDOHelper.getArrayClassLoader((Object[])obj);
        }
        return clazz.getClassLoader();
    }

    private static ClassLoader getCollectionClassLoader(Collection col) {
        Object[] arr = col.toArray();
        return JDOHelper.getArrayClassLoader(arr);
    }

    private static ClassLoader getArrayClassLoader(Object[] arr) {
        ClassLoader cl = null;
        for (int i = 0; i < arr.length && (cl = JDOHelper.getObjectClassLoader(arr[i])) == null; ++i) {
        }
        return cl;
    }
}

