/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.remote;

import com.sun.enterprise.admin.remote.ServerRemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.shell.ShellService;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.osgi.cli.remote.RemoteCommandSession;
import org.jvnet.hk2.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;

@Service(name="osgi")
@CommandLock(value=CommandLock.LockType.SHARED)
@I18n(value="osgi")
@PerLookup
@TargetType(value={CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="osgi", description="Remote OSGi Shell Access")})
@AccessRequired(resource={"domain/osgi/shell"}, action={"execute"})
public class OSGiShellCommand
implements AdminCommand,
PostConstruct {
    private static final Logger log = Logger.getLogger(OSGiShellCommand.class.getPackage().getName());
    private static final Map<String, RemoteCommandSession> sessions = new ConcurrentHashMap<String, RemoteCommandSession>();
    @Param(name="command-line", primary=true, optional=true, multiple=true, defaultValue="help")
    private Object commandLine;
    @Param(name="session", optional=true)
    private String sessionOp;
    @Param(name="session-id", optional=true)
    private String sessionId;
    @Param(name="instance", optional=true)
    private String instance;
    protected BundleContext ctx;
    @Inject
    ServiceLocator locator;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.instance != null) {
            Server svr = this.domain.getServerNamed(this.instance);
            if (svr == null) {
                report.setMessage("No server target found for " + this.instance);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String host = svr.getAdminHost();
            int port = svr.getAdminPort();
            try {
                ServerRemoteAdminCommand remote = new ServerRemoteAdminCommand(this.locator, "osgi", host, port, false, "admin", "", log);
                ParameterMap params = new ParameterMap();
                if (this.commandLine == null) {
                    params.set((Object)"DEFAULT".toLowerCase(Locale.US), (Object)"asadmin-osgi-shell");
                } else if (this.commandLine instanceof String) {
                    params.set((Object)"DEFAULT".toLowerCase(Locale.US), (Object)((String)this.commandLine));
                } else if (this.commandLine instanceof List) {
                    params.set((Object)"DEFAULT".toLowerCase(Locale.US), (Collection)((List)this.commandLine));
                }
                if (this.sessionOp != null) {
                    params.set((Object)"session", (Object)this.sessionOp);
                }
                if (this.sessionId != null) {
                    params.set((Object)"session-id", (Object)this.sessionId);
                }
                report.setMessage(remote.executeCommand(params));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            catch (CommandException x) {
                report.setMessage("Remote execution failed: " + x.getMessage());
                report.setFailureCause((Throwable)x);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        String cmdName = "";
        String cmd = "";
        if (this.commandLine == null) {
            cmdName = cmd = "asadmin-osgi-shell";
        } else if (this.commandLine instanceof String) {
            cmdName = cmd = (String)this.commandLine;
        } else if (this.commandLine instanceof List) {
            for (Object arg : (List)this.commandLine) {
                if (cmd.length() == 0) {
                    cmdName = cmd = (String)arg;
                    continue;
                }
                cmd = cmd + " " + (String)arg;
            }
        } else if (this.commandLine instanceof String[]) {
            for (String arg : (String[])this.commandLine) {
                if (cmd.length() == 0) {
                    cmdName = cmd = arg;
                    continue;
                }
                cmd = cmd + " " + arg;
            }
        } else {
            report.setMessage("Unable to deal with argument list of type " + this.commandLine.getClass().getName());
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(512);
        PrintStream out = new PrintStream(bOut);
        ByteArrayOutputStream bErr = new ByteArrayOutputStream(512);
        PrintStream err = new PrintStream(bErr);
        try {
            Object shell = null;
            ServiceReference sref = this.ctx.getServiceReference("org.apache.felix.service.command.CommandProcessor");
            if (sref != null) {
                shell = this.ctx.getService(sref);
            }
            if (shell == null) {
                sref = this.ctx.getServiceReference("org.apache.felix.shell.ShellService");
                if (sref != null) {
                    shell = this.ctx.getService(sref);
                }
                if (shell == null) {
                    report.setMessage("No Shell Service available");
                    report.setActionExitCode(ActionReport.ExitCode.WARNING);
                    return;
                }
                if ("asadmin-osgi-shell".equals(cmdName)) {
                    out.println("felix");
                } else {
                    ShellService s = (ShellService)shell;
                    s.executeCommand(cmd, out, err);
                }
            } else {
                InputStream in = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }

                    @Override
                    public int available() throws IOException {
                        return 0;
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return -1;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return -1;
                    }
                };
                CommandProcessor cp = (CommandProcessor)shell;
                if (this.sessionOp == null) {
                    if ("asadmin-osgi-shell".equals(cmdName)) {
                        out.println("gogo");
                    } else {
                        CommandSession session = cp.createSession(in, out, err);
                        session.execute((CharSequence)cmd);
                        session.close();
                    }
                } else if ("new".equals(this.sessionOp)) {
                    CommandSession session = cp.createSession(null, null, null);
                    RemoteCommandSession remote = new RemoteCommandSession(session);
                    log.log(Level.FINE, "Remote session established: {0}", remote.getId());
                    sessions.put(remote.getId(), remote);
                    out.println(remote.getId());
                } else if ("list".equals(this.sessionOp)) {
                    for (String id : sessions.keySet()) {
                        out.println(id);
                    }
                } else if ("execute".equals(this.sessionOp)) {
                    RemoteCommandSession remote = sessions.get(this.sessionId);
                    CommandSession session = remote.attach(in, out, err);
                    session.execute((CharSequence)cmd);
                    remote.detach();
                } else if ("stop".equals(this.sessionOp)) {
                    RemoteCommandSession remote = sessions.remove(this.sessionId);
                    CommandSession session = remote.attach(in, out, err);
                    session.close();
                    log.log(Level.FINE, "Remote session closed: {0}", remote.getId());
                }
            }
            out.flush();
            err.flush();
            String output = bOut.toString("UTF-8");
            String errors = bErr.toString("UTF-8");
            report.setMessage(output);
            if (errors.length() > 0) {
                report.setMessage(errors);
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (Exception ex) {
            report.setMessage(ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
    }

    public void postConstruct() {
        if (this.ctx == null) {
            Bundle me = ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle();
            this.ctx = me.getBundleContext();
        }
    }
}

