/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class ClientJarWriter {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private static final String EXCEPTION_CAUGHT = "NCLS-DEPLOYMENT-00004";
    private final String LINE_SEP = System.getProperty("line.separator");
    private final ExtendedDeploymentContext deploymentContext;
    private final String name;

    public ClientJarWriter(ExtendedDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
        this.name = VersioningUtils.getUntaggedName(((DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class)).name());
    }

    public void run() throws IOException {
        if (this.isArtifactsPresent()) {
            deplLogger.log(Level.FINE, "Skipping possible client JAR generation because it would already have been done");
            return;
        }
        Artifacts downloadableArtifacts = DeploymentUtils.downloadableArtifacts((DeploymentContext)this.deploymentContext);
        Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts((DeploymentContext)this.deploymentContext);
        File clientJarFile = this.createClientJARIfNeeded(this.deploymentContext, this.name);
        if (clientJarFile == null) {
            deplLogger.log(Level.FINE, "No client JAR generation is needed.");
        } else {
            deplLogger.log(Level.FINE, "Generated client JAR {0} for possible download", clientJarFile.getAbsolutePath());
            downloadableArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
            generatedArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
        }
    }

    private boolean isArtifactsPresent() {
        return this.deploymentContext.getCommandParameters(OpsParams.class).origin.isArtifactsPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createClientJARIfNeeded(ExtendedDeploymentContext deploymentContext, String appName) throws IOException {
        File generatedClientJARFile;
        block7: {
            ClientArtifactsManager clientArtifactsManager = ClientArtifactsManager.get((DeploymentContext)deploymentContext);
            Collection<Artifacts.FullAndPartURIs> artifacts = clientArtifactsManager.artifacts();
            if (artifacts.isEmpty()) {
                return null;
            }
            deploymentContext.prepareScratchDirs();
            artifacts = new ArrayList<Artifacts.FullAndPartURIs>(clientArtifactsManager.artifacts());
            String generatedClientJARName = ClientJarWriter.generatedClientJARNameAndType(appName);
            generatedClientJARFile = new File(deploymentContext.getScratchDir("xml"), generatedClientJARName);
            OutputJarArchive generatedClientJAR = new OutputJarArchive();
            try {
                try {
                    generatedClientJAR.create(generatedClientJARFile.toURI());
                    if (!this.isManifestPresent(artifacts)) {
                        deplLogger.log(Level.FINER, "Adding a simple manifest; one was not already generated");
                        this.addManifest(artifacts);
                    }
                    this.copyArtifactsToClientJAR(generatedClientJAR, artifacts);
                }
                finally {
                    generatedClientJAR.close();
                }
            }
            catch (IOException ex) {
                if (generatedClientJARFile.delete()) break block7;
                generatedClientJARFile.deleteOnExit();
            }
        }
        return generatedClientJARFile;
    }

    private boolean isManifestPresent(Collection<Artifacts.FullAndPartURIs> artifacts) {
        boolean isManifestPresent = false;
        for (Artifacts.FullAndPartURIs a : artifacts) {
            isManifestPresent |= a.getPart().toASCIIString().equals("META-INF/MANIFEST.MF");
        }
        return isManifestPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addManifest(Collection<Artifacts.FullAndPartURIs> artifacts) throws IOException {
        File mfFile = File.createTempFile("clientmf", ".MF");
        BufferedOutputStream mfOS = new BufferedOutputStream(new FileOutputStream(mfFile));
        try {
            Manifest mf = new Manifest();
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mf.write(mfOS);
        }
        finally {
            ((OutputStream)mfOS).close();
        }
        artifacts.add(new Artifacts.FullAndPartURIs(mfFile.toURI(), "META-INF/MANIFEST.MF", true));
    }

    private static String generatedClientJARNameAndType(String earName) {
        return ClientJarWriter.generatedClientJARPrefix(earName) + ".jar";
    }

    private static String generatedClientJARPrefix(String earName) {
        return earName + "Client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArtifactsToClientJAR(WritableArchive generatedClientJARArchive, Collection<Artifacts.FullAndPartURIs> artifacts) throws IOException {
        HashSet<String> pathsWrittenToJAR = new HashSet<String>();
        StringBuilder copiedFiles = deplLogger.isLoggable(Level.FINER) ? new StringBuilder() : null;
        for (Artifacts.FullAndPartURIs artifact : artifacts) {
            String artPath = artifact.getPart().getRawPath();
            int previousSlash = artPath.indexOf(47);
            while (previousSlash != -1) {
                String partialAncestorPath = artPath.substring(0, previousSlash + 1);
                if (!pathsWrittenToJAR.contains(partialAncestorPath)) {
                    generatedClientJARArchive.putNextEntry(partialAncestorPath);
                    generatedClientJARArchive.closeEntry();
                    pathsWrittenToJAR.add(partialAncestorPath);
                }
                previousSlash = artPath.indexOf(47, previousSlash + 1);
            }
            OutputStream os = generatedClientJARArchive.putNextEntry(artifact.getPart().toASCIIString());
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(new File(artifact.getFull())));
                DeploymentUtils.copyStream(is, os);
                if (copiedFiles == null) continue;
                copiedFiles.append(this.LINE_SEP).append("  ").append(artifact.getFull().toASCIIString()).append(" -> ").append(artifact.getPart().toASCIIString());
            }
            catch (IOException ex) {
                deplLogger.log(Level.WARNING, EXCEPTION_CAUGHT, ex.getLocalizedMessage());
            }
            finally {
                File artifactFile;
                if (is != null) {
                    is.close();
                }
                generatedClientJARArchive.closeEntry();
                if (!artifact.isTemporary() || (artifactFile = new File(artifact.getFull())).delete()) continue;
                artifactFile.deleteOnExit();
            }
        }
        if (copiedFiles != null) {
            deplLogger.log(Level.FINER, copiedFiles.toString());
        }
    }
}

