/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.container.Sniffer;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-components")
@I18n(value="list.components")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="list-components", description="list-components", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-components", description="list-components", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.GET, path="list-components", description="list-components", params={@RestParam(name="target", value="$parent")})})
public class ListComponentsCommand
implements AdminCommand {
    @Param(optional=true)
    String type = null;
    @Param(primary=true, optional=true)
    public String target = "server";
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    public Boolean long_opt = false;
    @Param(optional=true, defaultValue="false", shortName="t")
    public Boolean terse = false;
    @Param(optional=true, defaultValue="false")
    public Boolean subcomponents = false;
    @Param(optional=true, defaultValue="false")
    private Boolean resources = false;
    private static String[] validTypes = new String[]{"application", "appclient", "connector", "ejb", "web", "webservice"};
    @Inject
    protected Domain domain;
    @Inject
    SnifferManager snifferManager;
    @Inject
    CommandRunner commandRunner;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        List<String> validTypeList;
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        ArrayList<String[]> rowList = new ArrayList<String[]>();
        if (this.type != null && !(validTypeList = Arrays.asList(validTypes)).contains(this.type)) {
            report.setMessage(localStrings.getLocalString("list.components.invalid.type", "Invalid type option value."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (Application app : this.domain.getApplicationsInTarget(this.target)) {
            if (app.isLifecycleModule() || this.type != null && !this.isApplicationOfThisType(app, this.type)) continue;
            String[] currentRow = this.terse == false && this.long_opt != false ? new String[]{app.getName(), this.getAppSnifferEngines(app, true), this.getLongStatus(app)} : new String[]{app.getName(), this.getAppSnifferEngines(app, true)};
            part.addProperty(app.getName(), this.getAppSnifferEngines(app, false));
            rowList.add(currentRow);
            ++numOfApplications;
        }
        int numCols = 2;
        String[] headings = new String[]{"NAME", "TYPE", "STATUS"};
        int[] longestValue = new int[numCols];
        if (!this.terse.booleanValue() && this.long_opt.booleanValue()) {
            numCols = 3;
            longestValue = new int[]{headings[0].length(), headings[1].length(), headings[2].length()};
        }
        for (String[] v : rowList) {
            for (int i = 0; i < v.length; ++i) {
                if (v[i].length() <= longestValue[i]) continue;
                longestValue[i] = v[i].length();
            }
        }
        StringBuilder formattedLineBuf = new StringBuilder();
        for (int i = 0; i < numCols; ++i) {
            int n = i;
            longestValue[n] = longestValue[n] + 2;
            formattedLineBuf.append("%-").append(longestValue[i]).append("s");
        }
        String formattedLine = formattedLineBuf.toString();
        if (!this.terse.booleanValue()) {
            if (rowList.isEmpty()) {
                part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
            } else if (this.long_opt.booleanValue()) {
                ActionReport.MessagePart childPart = part.addChild();
                childPart.setMessage(String.format(formattedLine, headings));
            }
        }
        for (String[] v : rowList) {
            StringBuilder sb = new StringBuilder();
            ActionReport.MessagePart childPart = part.addChild();
            sb.append(String.format(formattedLine, v));
            if (this.resources.booleanValue()) {
                this.displayAppScopedResources(v[0], report, childPart);
            }
            if (this.subcomponents.booleanValue()) {
                this.displaySubComponents(v[0], report, childPart);
            }
            childPart.setMessage(sb.toString());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String getLongStatus(Application app) {
        String message = "";
        boolean isVersionEnabled = this.domain.isAppEnabledInTarget(app.getName(), this.target);
        message = isVersionEnabled ? localStrings.getLocalString("list.applications.verbose.enabled", "enabled") : localStrings.getLocalString("list.applications.verbose.disabled", "disabled");
        return message;
    }

    boolean isApplicationOfThisType(Application app, String type) {
        if (type.equals("application")) {
            type = "ear";
        } else if (type.equals("webservice")) {
            type = "webservices";
        }
        List<Engine> engineList = this.getAppEngines(app);
        for (Engine engine : engineList) {
            if (!engine.getSniffer().equals(type)) continue;
            return true;
        }
        return false;
    }

    String getAppSnifferEngines(Application app, boolean format) {
        return this.getSniffers(this.getAppEngines(app), format);
    }

    String getSnifferEngines(Module module, boolean format) {
        return this.getSniffers(module.getEngines(), format);
    }

    private String getSniffers(List<Engine> engineList, boolean format) {
        LinkedHashSet<String> snifferSet = new LinkedHashSet<String>();
        for (Engine engine : engineList) {
            String engType = engine.getSniffer();
            if (!this.displaySnifferEngine(engType)) continue;
            snifferSet.add(engine.getSniffer());
        }
        StringBuffer se = new StringBuffer();
        if (!snifferSet.isEmpty()) {
            if (format) {
                se.append("<");
            }
            for (String sniffer : snifferSet) {
                se.append(sniffer + ", ");
            }
            if (se.length() > 2) {
                se.replace(se.length() - 2, se.length(), format ? ">" : "");
            } else if (format) {
                se.append(">");
            }
        }
        return se.toString();
    }

    private List<Engine> getAppEngines(Application app) {
        ArrayList<Engine> engineList = new ArrayList<Engine>();
        engineList.addAll(app.getEngine());
        for (Module module : app.getModule()) {
            engineList.addAll(module.getEngines());
        }
        return engineList;
    }

    boolean displaySnifferEngine(String engType) {
        Sniffer sniffer = this.snifferManager.getSniffer(engType);
        return sniffer.isUserVisible();
    }

    private void displayAppScopedResources(String applicationName, ActionReport report, ActionReport.MessagePart part) {
        Application application = null;
        List applications = this.domain.getApplicationsInTarget(this.target);
        for (Application app : applications) {
            if (!app.getName().equals(applicationName)) continue;
            application = app;
        }
        if (application != null) {
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("_list-resources", subReport);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"appname", (Object)application.getName());
            inv.parameters(parameters).execute();
            ActionReport.MessagePart subPart = subReport.getTopMessagePart();
            for (ActionReport.MessagePart cp : subPart.getChildren()) {
                ActionReport.MessagePart resourcesChildPart = part.addChild();
                resourcesChildPart.setMessage(cp.getMessage());
            }
        }
    }

    private void displaySubComponents(String appName, ActionReport report, ActionReport.MessagePart part) {
        ActionReport subReport = report.addSubActionsReport();
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("list-sub-components", subReport);
        ParameterMap parameters = new ParameterMap();
        parameters.add((Object)"DEFAULT", (Object)appName);
        parameters.add((Object)"terse", (Object)"true");
        parameters.add((Object)"resources", (Object)this.resources.toString());
        inv.parameters(parameters).execute();
        ActionReport.MessagePart subPart = subReport.getTopMessagePart();
        for (ActionReport.MessagePart childPart : subPart.getChildren()) {
            ActionReport.MessagePart actualChildPart = part.addChild();
            actualChildPart.setMessage("  " + childPart.getMessage());
            for (ActionReport.MessagePart grandChildPart : childPart.getChildren()) {
                actualChildPart.addChild().setMessage(grandChildPart.getMessage());
            }
        }
    }
}

