/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.j2ee.J2EEServerImpl;
import org.glassfish.admin.amx.impl.j2ee.JVMImpl;
import org.glassfish.admin.amx.impl.j2ee.Metadata;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;

public class DASJ2EEServerImpl
extends J2EEServerImpl
implements NotificationListener {
    static final String DAS_SERVER_NAME = "server";

    public DASJ2EEServerImpl(ObjectName parentObjectName, Metadata meta) {
        super(parentObjectName, meta);
        Issues.getAMXIssues().notDone("DASJ2EEServer needs to account for DAS/non-DAS");
    }

    protected void registerChildren() {
        super.registerChildren();
        ObjectNameBuilder builder = this.getObjectNames();
        JVMImpl jvm = new JVMImpl(this.getObjectName(), this.defaultChildMetadata());
        ObjectName jvmObjectName = builder.buildChildObjectName("JVM", null);
        this.registerChild((Object)jvm, jvmObjectName);
    }

    private boolean remoteServerIsRunning() {
        return 1 == this.getstate();
    }

    private boolean remoteServerIsStartable() {
        int cState = this.getstate();
        return 3 == cState || 4 == cState;
    }

    private boolean remoteServerIsStoppable() {
        int cState = this.getstate();
        return 0 == cState || 1 == cState || 4 == cState;
    }

    public void handleNotification(Notification notif, Object ignore) {
        String notifType = notif.getType();
    }

    protected String getServerName() {
        return Util.getNameProp((ObjectName)this.getObjectName());
    }

    public boolean isstateManageable() {
        return false;
    }

    public int getstate() {
        int state = 3;
        try {
            Issues.getAMXIssues().notDone("DASJ2EEServerImpl.getRuntimeStatus: getRuntimeStatus");
            state = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    public void start() {
        if (!this.remoteServerIsStartable()) {
            throw new RuntimeException("server is not in a startable state");
        }
        this.startRemoteServer();
    }

    public void startRecursive() {
        this.start();
    }

    private boolean isDASJ2EEServer() {
        return DAS_SERVER_NAME.equals(this.getName());
    }

    public void stop() {
        if (!this.isDASJ2EEServer() && !this.remoteServerIsStoppable()) {
            throw new RuntimeException("server is not in a stoppable state");
        }
    }

    private void startRemoteServer() {
        Issues.getAMXIssues().notDone("DASJ2EEServerImpl.startRemoteServer");
    }

    private void stopRemoteServer() {
        Issues.getAMXIssues().notDone("DASJ2EEServerImpl.stopRemoteServer");
    }
}

