/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.StopLocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-local-instance")
@Scoped(value=PerLookup.class)
public class RestartLocalInstanceCommand
extends StopLocalInstanceCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private Habitat habitat;

    protected final int doRemoteCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restart.notRestartable"));
        }
        long uptimeOldServer = this.getUptime();
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long timestamp = pwFile != null ? pwFile.lastModified() : -1L;
        RemoteCommand cmd = new RemoteCommand("_restart-instance", this.programOpts, this.env);
        if (this.debug != null) {
            cmd.executeAndReturnOutput(new String[]{"_restart-instance", "--debug", this.debug.toString()});
        } else {
            cmd.executeAndReturnOutput(new String[]{"_restart-instance"});
        }
        this.waitForRestart(pwFile, timestamp, uptimeOldServer);
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.warning(Strings.get("restart.instanceNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getComponent(CLICommand.class, "start-local-instance");
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-local-instance");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.nodeDir != null) {
            opts.add("--nodedir");
            opts.add(this.nodeDir);
        }
        if (this.node != null) {
            opts.add("--node");
            opts.add(this.node);
        }
        if (this.instanceName != null) {
            opts.add(this.instanceName);
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }
}

