/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.Payload;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="import-sync-bundle")
@Scoped(value=PerLookup.class)
public class ImportSyncBundleCommand
extends LocalInstanceCommand {
    @Param(name="file_name", primary=true)
    private String syncBundle;
    @Param(name="instance")
    private String instanceName0;
    @Param(name="node", optional=true, alias="nodeagent")
    protected String _node;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    private File dasPropsFile;
    private Properties dasProperties;
    protected boolean setDasDefaultsOnly = false;
    private File syncBundleFile = null;
    private File agentConfigDir;
    private File backupDir;
    private static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private String INSTANCE_DOTTED_NAME;
    private String RENDEZVOUS_DOTTED_NAME;

    protected void validate() throws CommandException {
        if (!ImportSyncBundleCommand.ok((String)this.instanceName0)) {
            throw new CommandException(Strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        this.syncBundleFile = new File(this.syncBundle);
        if (!this.syncBundleFile.isFile()) {
            throw new CommandException(Strings.get("noFile", this.syncBundle));
        }
        if (!this.isRegisteredToDAS()) {
            throw new CommandException(Strings.get("import.sync.bundle.invalidInstance", this.instanceName));
        }
        this.node = this._node;
        super.validate();
        this.init();
    }

    private void init() throws CommandException {
        this.agentConfigDir = new File(this.nodeDirChild, "agent" + File.separator + "config");
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        if (this.dasPropsFile.isFile()) {
            this.setDasDefaults(this.dasPropsFile);
        }
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        this.DASProtocol = "http";
        this.INSTANCE_DOTTED_NAME = "servers.server." + this.instanceName;
        this.RENDEZVOUS_DOTTED_NAME = this.INSTANCE_DOTTED_NAME + ".property." + RENDEZVOUS_PROPERTY_NAME;
    }

    private boolean isRegisteredToDAS() throws CommandException {
        boolean isRegisteredOnDAS;
        block8: {
            isRegisteredOnDAS = false;
            InputStream input = null;
            XMLStreamReader reader = null;
            try {
                ZipFile zip = new ZipFile(this.syncBundleFile);
                ZipEntry entry = zip.getEntry("config/domain.xml");
                if (entry != null) {
                    int event;
                    input = zip.getInputStream(entry);
                    reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
                    while (!isRegisteredOnDAS && (event = reader.next()) != 8) {
                        if (event != 1 || !"server".equals(reader.getLocalName())) continue;
                        int num = reader.getAttributeCount();
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (int i = 0; i < num; ++i) {
                            map.put(reader.getAttributeName(i).getLocalPart(), reader.getAttributeValue(i));
                        }
                        String thisName = (String)map.get("name");
                        if (!this.instanceName.equals(thisName)) continue;
                        isRegisteredOnDAS = true;
                        if (this._node != null) continue;
                        this._node = (String)map.get("node");
                    }
                    if (input != null) {
                        input.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    break block8;
                }
                throw new CommandException(Strings.get("import.sync.bundle.domainXmlNotFound", this.syncBundle));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, ex.getLocalizedMessage()), ex);
                throw new CommandException(Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, ex.getLocalizedMessage()), (Throwable)ex);
            }
            catch (XMLStreamException xe) {
                logger.log(Level.SEVERE, Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, xe.getLocalizedMessage()), xe);
                throw new CommandException(Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, xe.getLocalizedMessage()), (Throwable)xe);
            }
        }
        return isRegisteredOnDAS;
    }

    protected int executeCommand() throws CommandException {
        int exitCode = this.createDirectories();
        if (exitCode == 0) {
            this.setRendezvousOccurred("true");
        }
        return exitCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int createDirectories() throws CommandException {
        if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
            throw new CommandException(Strings.get("import.sync.bundle.createDirectoryFailed", this.agentConfigDir.getPath()));
        }
        this.writeProperties();
        FileInputStream in = null;
        PayloadImpl.Inbound payload = null;
        try {
            in = new FileInputStream(this.syncBundle);
            payload = PayloadImpl.Inbound.newInstance((String)"application/zip", (InputStream)in);
        }
        catch (IOException ex) {
            try {
                if (in == null) throw new CommandException(Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, ex.getLocalizedMessage()), (Throwable)ex);
                in.close();
                throw new CommandException(Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, ex.getLocalizedMessage()), (Throwable)ex);
            }
            catch (IOException ioe) {
                logger.warning(Strings.get("import.sync.bundle.closeStreamFailed", this.syncBundle, ioe.getLocalizedMessage()));
            }
            throw new CommandException(Strings.get("import.sync.bundle.inboundPayloadFailed", this.syncBundle, ex.getLocalizedMessage()), (Throwable)ex);
        }
        this.backupInstanceDir();
        File targetDir = this.getServerDirs().getServerDir();
        if (!targetDir.mkdirs()) {
            this.restoreInstanceDir();
            throw new CommandException(Strings.get("import.sync.bundle.createDirectoryFailed", targetDir.getPath()));
        }
        PayloadFilesManager.Perm perm = new PayloadFilesManager.Perm(targetDir, null, logger);
        try {
            perm.processParts((Payload.Inbound)payload);
        }
        catch (Exception ex) {
            try {
                this.restoreInstanceDir();
                String msg = Strings.get("import.sync.bundle.extractBundleFailed", this.syncBundle, targetDir.getAbsolutePath());
                if (ex.getLocalizedMessage() == null) throw new CommandException(msg, (Throwable)ex);
                msg = msg + "\n" + ex.getLocalizedMessage();
                throw new CommandException(msg, (Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    logger.warning(Strings.get("import.sync.bundle.closeStreamFailed", this.syncBundle, ex2.getLocalizedMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            logger.warning(Strings.get("import.sync.bundle.closeStreamFailed", this.syncBundle, ex.getLocalizedMessage()));
        }
        this.deleteBackupDir();
        return 0;
    }

    private void writeProperties() throws CommandException {
        try {
            if (!this.dasPropsFile.isFile()) {
                this.writeDasProperties();
            }
        }
        catch (IOException ex) {
            throw new CommandException(Strings.get("Instance.cantWriteProperties", "das.properties", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDasProperties() throws IOException {
        if (this.dasPropsFile.createNewFile()) {
            this.dasProperties = new Properties();
            this.dasProperties.setProperty("agent.das.host", this.DASHost);
            this.dasProperties.setProperty("agent.das.port", String.valueOf(this.DASPort));
            this.dasProperties.setProperty("agent.das.isSecure", String.valueOf(this.dasIsSecure));
            this.dasProperties.setProperty("agent.das.protocol", this.DASProtocol);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.dasPropsFile);
                this.dasProperties.store(fos, Strings.get("Instance.dasPropertyComment"));
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    private void backupInstanceDir() throws CommandException {
        File f = this.getServerDirs().getServerDir();
        if (f != null && f.isDirectory()) {
            Random r = new Random();
            this.setBackupDir(r.nextInt());
            File backup = this.getBackupDir();
            if (!f.renameTo(backup)) {
                logger.warning(Strings.get("import.sync.bundle.backupInstanceDirFailed", f.getAbsolutePath(), backup.getAbsolutePath()));
                if (FileUtils.whack((File)f)) {
                    logger.warning(Strings.get("import.sync.bundle.deletedInstanceDir", f.getAbsolutePath()));
                }
            }
        }
    }

    private void setBackupDir(int i) {
        File f = this.getServerDirs().getServerDir();
        this.backupDir = new File(this.getServerDirs().getServerParentDir(), f.getName() + "_backup" + i);
    }

    private File getBackupDir() {
        return this.backupDir;
    }

    private void restoreInstanceDir() {
        File backup = this.getBackupDir();
        if (backup != null && backup.isDirectory()) {
            this.getServerDirs().getServerDir().delete();
            if (!backup.renameTo(this.getServerDirs().getServerDir())) {
                logger.warning(Strings.get("import.sync.bundle.restoreInstanceDirFailed", backup.getAbsolutePath(), this.getServerDirs().getServerDir().getAbsolutePath()));
            }
        }
    }

    private void deleteBackupDir() {
        File backup = this.getBackupDir();
        if (backup != null && backup.isDirectory()) {
            FileUtils.whack((File)backup);
        }
    }

    private void setRendezvousOccurred(String rendezVal) {
        String dottedName = this.RENDEZVOUS_DOTTED_NAME + "=" + rendezVal;
        try {
            RemoteCommand rc = new RemoteCommand("set", this.programOpts, this.env);
            rc.executeAndReturnOutput(new String[]{"set", dottedName});
        }
        catch (CommandException ex) {
            logger.warning(Strings.get("import.sync.bundle.completeRegistrationFailed", dottedName));
        }
    }
}

