/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.testing.ArrayValue;
import org.glassfish.admin.rest.testing.BooleanValue;
import org.glassfish.admin.rest.testing.Common;
import org.glassfish.admin.rest.testing.DoubleValue;
import org.glassfish.admin.rest.testing.IndentingStringBuffer;
import org.glassfish.admin.rest.testing.IntValue;
import org.glassfish.admin.rest.testing.LongValue;
import org.glassfish.admin.rest.testing.NilValue;
import org.glassfish.admin.rest.testing.StringValue;
import org.glassfish.admin.rest.testing.Value;

public class ObjectValue
extends Value {
    private boolean ignoreExtra;
    private Map<String, Value> properties = new HashMap<String, Value>();

    ObjectValue() {
    }

    public boolean isIgnoreExtra() {
        return this.ignoreExtra;
    }

    public ObjectValue ignoreExtra(boolean val) {
        this.ignoreExtra = val;
        return this;
    }

    public ObjectValue ignoreExtra() {
        return this.ignoreExtra(true);
    }

    Map<String, Value> getProperties() {
        return this.properties;
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public ObjectValue put(String propertyName, Value propertyValue) {
        if (propertyValue == null) {
            propertyValue = Common.nilVal();
        }
        this.getProperties().put(propertyName, propertyValue);
        return this;
    }

    public ObjectValue put(String propertyName, String propertyValue) {
        StringValue val = propertyValue != null ? Common.stringVal(propertyValue) : null;
        return this.put(propertyName, val);
    }

    public ObjectValue put(String propertyName, long propertyValue) {
        return this.put(propertyName, Common.longVal(propertyValue));
    }

    public ObjectValue put(String propertyName, int propertyValue) {
        return this.put(propertyName, Common.intVal(propertyValue));
    }

    public ObjectValue put(String propertyName, double propertyValue) {
        return this.put(propertyName, Common.doubleVal(propertyValue));
    }

    public ObjectValue put(String propertyName, boolean propertyValue) {
        return this.put(propertyName, Common.booleanVal(propertyValue));
    }

    public ObjectValue put(String propertyName) {
        return this.put(propertyName, Common.nilVal());
    }

    public ObjectValue remove(String propertyName) {
        if (this.has(propertyName)) {
            this.getProperties().remove(propertyName);
        }
        return this;
    }

    public boolean has(String propertyName) {
        return this.getProperties().containsKey(propertyName);
    }

    public Value get(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    public ObjectValue getObjectVal(String propertyName) {
        return (ObjectValue)this.get(propertyName);
    }

    public ArrayValue getArrayVal(String propertyName) {
        return (ArrayValue)this.get(propertyName);
    }

    public StringValue getStringVal(String propertyName) {
        return (StringValue)this.get(propertyName);
    }

    public LongValue getLongVal(String propertyName) {
        return (LongValue)this.get(propertyName);
    }

    public IntValue getIntVal(String propertyName) {
        return (IntValue)this.get(propertyName);
    }

    public DoubleValue getDoubleVal(String propertyName) {
        return (DoubleValue)this.get(propertyName);
    }

    public BooleanValue getBooleanVal(String propertyName) {
        return (BooleanValue)this.get(propertyName);
    }

    public NilValue getNilVal(String propertyName) {
        return (NilValue)this.get(propertyName);
    }

    @Override
    Object getJsonValue() throws Exception {
        if (this.isIgnoreExtra()) {
            throw new IllegalStateException("Cannot be converted to json because ignoreExtra is true");
        }
        JSONObject o = new JSONObject();
        for (Map.Entry<String, Value> p : this.getProperties().entrySet()) {
            o.put(p.getKey(), p.getValue().getJsonValue());
        }
        return o;
    }

    public JSONObject toJSONObject() throws Exception {
        return (JSONObject)this.getJsonValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void print(IndentingStringBuffer sb) {
        sb.println("objectValue ignoreExtra=" + this.isIgnoreExtra());
        sb.indent();
        try {
            for (Map.Entry<String, Value> p : this.getProperties().entrySet()) {
                sb.println("property name=" + p.getKey());
                sb.indent();
                try {
                    p.getValue().print(sb);
                }
                finally {
                    sb.undent();
                }
            }
        }
        finally {
            sb.undent();
        }
    }
}

