/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.testing.ArrayValue;
import org.glassfish.admin.rest.testing.BooleanValue;
import org.glassfish.admin.rest.testing.DataVerifier;
import org.glassfish.admin.rest.testing.DoubleValue;
import org.glassfish.admin.rest.testing.Environment;
import org.glassfish.admin.rest.testing.IndentingStringBuffer;
import org.glassfish.admin.rest.testing.IntValue;
import org.glassfish.admin.rest.testing.LongValue;
import org.glassfish.admin.rest.testing.NilValue;
import org.glassfish.admin.rest.testing.ObjectValue;
import org.glassfish.admin.rest.testing.Response;
import org.glassfish.admin.rest.testing.ResponseBody;
import org.glassfish.admin.rest.testing.ResponseVerifier;
import org.glassfish.admin.rest.testing.StringValue;
import org.glassfish.admin.rest.testing.Value;

public class Common {
    public static final int SC_OK = Response.Status.OK.getStatusCode();
    public static final int SC_CREATED = Response.Status.CREATED.getStatusCode();
    public static final int SC_ACCEPTED = Response.Status.ACCEPTED.getStatusCode();
    public static final int SC_NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    public static final int SC_BAD_REQUEST = Response.Status.BAD_REQUEST.getStatusCode();
    public static final int SC_UNAUTHORIZED = Response.Status.UNAUTHORIZED.getStatusCode();
    public static final int SC_ANY = -1;
    public static final String PROP_ITEM = "item";
    public static final String PROP_ITEMS = "items";
    public static final String PROP_RESOURCES = "resources";
    public static final String PROP_MESSAGES = "messages";
    public static final String REL_ACTION = "action";
    public static final String REL_PARENT = "parent";
    public static final String QUERY_DETACHED = "__detached";
    public static final String QUERY_INCLUDE = "__includeFields";
    public static final String QUERY_EXCLUDE = "__excludeFields";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_X_LOCATION = "X-Location";

    public static boolean haveValue(String val) {
        return val != null && val.length() > 0;
    }

    public static ObjectValue objectVal() {
        return new ObjectValue();
    }

    public static ArrayValue arrayVal() {
        return new ArrayValue();
    }

    public static StringValue stringVal() {
        return new StringValue();
    }

    public static StringValue stringVal(String value) {
        return Common.stringVal().value(value);
    }

    public static StringValue stringRegexp(String regexp) {
        return (StringValue)Common.stringVal().regexp(regexp);
    }

    public static StringValue anyString() {
        return Common.stringRegexp(".*");
    }

    public static StringValue regexp(String regexp) {
        return Common.stringRegexp(regexp);
    }

    public static LongValue longVal() {
        return new LongValue();
    }

    public static LongValue longVal(long value) {
        return Common.longVal().value(value);
    }

    public static LongValue longRegexp(String regexp) {
        return (LongValue)Common.longVal().regexp(regexp);
    }

    public static LongValue anyLong() {
        return Common.longRegexp(".*");
    }

    public static IntValue intVal() {
        return new IntValue();
    }

    public static IntValue intVal(int value) {
        return Common.intVal().value(value);
    }

    public static IntValue intRegexp(String regexp) {
        return (IntValue)Common.intVal().regexp(regexp);
    }

    public static IntValue anyInt() {
        return Common.intRegexp(".*");
    }

    public static DoubleValue doubleVal() {
        return new DoubleValue();
    }

    public static DoubleValue doubleVal(double value) {
        return Common.doubleVal().value(value);
    }

    public static DoubleValue doubleRegexp(String regexp) {
        return (DoubleValue)Common.doubleVal().regexp(regexp);
    }

    public static DoubleValue anyDouble() {
        return Common.doubleRegexp(".*");
    }

    public static BooleanValue booleanVal() {
        return new BooleanValue();
    }

    public static BooleanValue booleanVal(boolean value) {
        return Common.booleanVal().value(value);
    }

    public static BooleanValue booleanRegexp(String regexp) {
        return (BooleanValue)Common.booleanVal().regexp(regexp);
    }

    public static BooleanValue anyBoolean() {
        return Common.booleanRegexp(".*");
    }

    public static BooleanValue trueVal() {
        return Common.booleanVal(true);
    }

    public static BooleanValue falseVal() {
        return Common.booleanVal(false);
    }

    public static NilValue nilVal() {
        return new NilValue();
    }

    public static ObjectValue anySuccessMessage() {
        return Common.successMessage(".*");
    }

    public static ObjectValue anySuccessMessage(String field) {
        return Common.successMessage(field, ".*");
    }

    public static ArrayValue oneSuccessMessage() {
        return Common.arrayVal().add(Common.anySuccessMessage());
    }

    public static ObjectValue anyFailureMessage() {
        return Common.failureMessage(".*");
    }

    public static ObjectValue anyFailureMessage(String field) {
        return Common.failureMessage(field, ".*");
    }

    public static ArrayValue oneFailureMessage() {
        return Common.arrayVal().add(Common.anyFailureMessage());
    }

    public static ObjectValue anyWarningMessage() {
        return Common.warningMessage(".*");
    }

    public static ObjectValue anyWarningMessage(String field) {
        return Common.warningMessage(field, ".*");
    }

    public static ArrayValue oneWarningMessage() {
        return Common.arrayVal().add(Common.anyWarningMessage());
    }

    public static ObjectValue successMessage(String message) {
        return Common.message("SUCCESS", message);
    }

    public static ObjectValue successMessage(String field, String message) {
        return Common.message("SUCCESS", field, message);
    }

    public static ObjectValue failureMessage(String message) {
        return Common.message("FAILURE", message);
    }

    public static ObjectValue failureMessage(String field, String message) {
        return Common.message("FAILURE", field, message);
    }

    public static ObjectValue warningMessage(String message) {
        return Common.message("WARNING", message);
    }

    public static ObjectValue warningMessage(String field, String message) {
        return Common.message("WARNING", field, message);
    }

    public static ObjectValue message(String severity, String message) {
        return Common.objectVal().put("severity", Common.stringVal(severity)).put("message", Common.stringRegexp(message));
    }

    public static ObjectValue message(String severity, String field, String message) {
        return Common.objectVal().put("severity", severity).put("field", field).put("message", Common.stringRegexp(message));
    }

    public static ObjectValue rootResource(String rel) {
        return Common.objectVal().put("rel", rel).put("uri", Common.anyString());
    }

    public static ObjectValue resource(String rel, String title, String uri) {
        return Common.resource(rel, uri).put("title", Common.stringVal(title));
    }

    public static ObjectValue resource(String rel, String uri) {
        return Common.objectVal().put("rel", rel).put("uri", Common.stringRegexp(".*/" + uri));
    }

    public static String print(Value value) {
        IndentingStringBuffer sb = new IndentingStringBuffer();
        value.print(sb);
        return sb.toString();
    }

    public static ResponseBody responseBody() {
        return new ResponseBody();
    }

    public static ResponseVerifier verifier(Environment environment, Response response) {
        return new ResponseVerifier(environment, response);
    }

    public static ResponseVerifier verify(ResponseVerifier verifier, ObjectValue body, int ... statuses) throws Exception {
        return verifier.status(statuses).body(body);
    }

    public static ResponseVerifier verify(ResponseVerifier verifier, StringValue body, int ... statuses) throws Exception {
        return verifier.status(statuses).body(body);
    }

    public static ResponseVerifier verify(ResponseVerifier verifier, int ... statuses) throws Exception {
        return verifier.status(statuses);
    }

    public static void verify(Environment environment, ObjectValue want, JSONObject have) throws Exception {
        DataVerifier.verify(environment, want, have);
    }

    public static ObjectValue cloneObjectVal(ObjectValue v) throws Exception {
        return Common.toObjectVal(v.toJSONObject());
    }

    public static ObjectValue toObjectVal(JSONObject j) throws Exception {
        return (ObjectValue)Common.toValue(j);
    }

    public static ArrayValue toArrayVal(JSONArray j) throws Exception {
        return (ArrayValue)Common.toValue(j);
    }

    private static Value toValue(Object j) throws Exception {
        if (j instanceof String) {
            return Common.stringVal().value((String)j);
        }
        if (j instanceof Long) {
            return Common.longVal().value((Long)j);
        }
        if (j instanceof Integer) {
            return Common.intVal().value((Integer)j);
        }
        if (j instanceof Double) {
            return Common.doubleVal().value((Double)j);
        }
        if (j instanceof Boolean) {
            return Common.booleanVal().value((Boolean)j);
        }
        if (JSONObject.NULL == j) {
            return Common.nilVal();
        }
        if (j instanceof JSONObject) {
            JSONObject jo = (JSONObject)j;
            ObjectValue ov = Common.objectVal();
            Iterator i = jo.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                ov.put(key, Common.toValue(jo.get(key)));
            }
            return ov;
        }
        if (j instanceof JSONArray) {
            JSONArray ja = (JSONArray)j;
            ArrayValue av = Common.arrayVal();
            for (int i = 0; i < ja.length(); ++i) {
                av.add(Common.toValue(ja.get(i)));
            }
            return av;
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(j) + " to a Value");
    }
}

