/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigLoader;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.StringUtils;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigExtensionMethod;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface Domain
extends ConfigBeanProxy,
PropertyBag,
SystemPropertyBag,
ConfigLoader {
    public static final String DOMAIN_NAME_PROPERTY = "administrative.domain.name";

    @Attribute
    public String getApplicationRoot();

    public void setApplicationRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLogRoot();

    public void setLogRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocale();

    public void setLocale(String var1) throws PropertyVetoException;

    @Attribute
    public String getVersion();

    @Element
    public SecureAdmin getSecureAdmin();

    public void setSecureAdmin(SecureAdmin var1);

    @Element
    @NotNull
    public Applications getApplications();

    public void setApplications(Applications var1) throws PropertyVetoException;

    @Element
    @NotNull
    public SystemApplications getSystemApplications();

    public void setSystemApplications(SystemApplications var1) throws PropertyVetoException;

    @Element
    @NotNull
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @Element(required=true)
    @NotNull
    public Configs getConfigs();

    public void setConfigs(Configs var1) throws PropertyVetoException;

    @Element(required=true)
    @NotNull
    public Servers getServers();

    public void setServers(Servers var1) throws PropertyVetoException;

    @Element
    @NotNull
    public Clusters getClusters();

    public void setClusters(Clusters var1) throws PropertyVetoException;

    @Element
    public Nodes getNodes();

    public void setNodes(Nodes var1) throws PropertyVetoException;

    @Element
    public NodeAgents getNodeAgents();

    public void setNodeAgents(NodeAgents var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Any more legal system properties?")
    @PropertiesDesc(systemProperties=true, props={@PropertyDesc(name="com.sun.aas.installRoot", description="Operating system dependent. Path to the directory where the server is installed"), @PropertyDesc(name="com.sun.aas.instanceRoot", description="Operating system dependent. Path to the top level directory for a server instance"), @PropertyDesc(name="com.sun.aas.hostName", description="Operating system dependent. Path to the name of the host (machine)"), @PropertyDesc(name="com.sun.aas.javaRoot", description="Operating system dependent. Path to the library directory for the Sun GlassFish Message Queue software"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.configName", defaultValue="server-config", description="Name of the <config> used by a server instance"), @PropertyDesc(name="com.sun.aas.instanceName", defaultValue="server1", description="Name of the server instance. Not used in the default configuration, but can be used to customize configuration"), @PropertyDesc(name="com.sun.aas.domainName", defaultValue="domain1", description="Name of the domain. Not used in the default configuration, but can be used to customize configuration")})
    @Element
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Element(value="*")
    public List<DomainExtension> getExtensions();

    default public String getName() {
        return this.getPropertyValue(DOMAIN_NAME_PROPERTY);
    }

    default public List<Application> getAllDefinedSystemApplications() {
        ArrayList<Application> allSysApps = new ArrayList<Application>();
        SystemApplications sysApps = this.getSystemApplications();
        if (sysApps != null) {
            for (ApplicationName module : sysApps.getModules()) {
                if (!(module instanceof Application)) continue;
                allSysApps.add((Application)module);
            }
        }
        return Collections.unmodifiableList(allSysApps);
    }

    default public ApplicationRef getApplicationRefInServer(String serverName, String appName) {
        Server server = null;
        for (Server srv : this.getServers().getServer()) {
            if (!srv.getName().equals(serverName)) continue;
            server = srv;
            break;
        }
        ApplicationRef appRef = null;
        if (server != null) {
            for (ApplicationRef ref : server.getApplicationRef()) {
                if (!ref.getRef().equals(appName)) continue;
                appRef = ref;
                break;
            }
        }
        return appRef;
    }

    default public List<ApplicationRef> getApplicationRefsInServer(String serverName) {
        Server server = this.getServerNamed(serverName);
        if (server != null) {
            return server.getApplicationRef();
        }
        return List.of();
    }

    default public List<Application> getSystemApplicationsReferencedFrom(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        List<Application> allSysApps = this.getAllDefinedSystemApplications();
        if (allSysApps.isEmpty()) {
            return allSysApps;
        }
        ArrayList<Application> referencedApps = new ArrayList<Application>();
        for (ApplicationRef ref : this.getServerNamed(serverName).getApplicationRef()) {
            for (Application app : allSysApps) {
                if (!ref.getRef().equals(app.getName())) continue;
                referencedApps.add(app);
            }
        }
        return Collections.unmodifiableList(referencedApps);
    }

    default public Application getSystemApplicationReferencedFrom(String serverName, String appName) {
        for (Application app : this.getSystemApplicationsReferencedFrom(serverName)) {
            if (!app.getName().equals(appName)) continue;
            return app;
        }
        return null;
    }

    default public boolean isNamedSystemApplicationReferencedFrom(String appName, String serverName) {
        for (Application app : this.getSystemApplicationsReferencedFrom(serverName)) {
            if (!app.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    default public Server getServerNamed(String serverName) {
        Servers servers = this.getServers();
        if (servers == null || serverName == null) {
            throw new IllegalArgumentException("no <servers> element");
        }
        for (Server server : servers.getServer()) {
            if (!serverName.equals(server.getName().trim())) continue;
            return server;
        }
        return null;
    }

    default public boolean isServer(String serverName) {
        return this.getServerNamed(serverName) != null;
    }

    default public Config getConfigNamed(String configName) {
        Configs configs = this.getConfigs();
        if (configs == null || configName == null) {
            throw new IllegalArgumentException("no <config> element");
        }
        for (Config config : configs.getConfig()) {
            if (!configName.equals(config.getName().trim())) continue;
            return config;
        }
        return null;
    }

    default public Cluster getClusterNamed(String clusterName) {
        Clusters clusters = this.getClusters();
        if (clusters == null || clusterName == null) {
            return null;
        }
        for (Cluster cluster : clusters.getCluster()) {
            if (!clusterName.equals(cluster.getName().trim())) continue;
            return cluster;
        }
        return null;
    }

    default public Node getNodeNamed(String nodeName) {
        Nodes nodes = this.getNodes();
        if (nodes == null || nodeName == null) {
            return null;
        }
        for (Node node : nodes.getNode()) {
            if (!nodeName.equals(node.getName().trim())) continue;
            return node;
        }
        return null;
    }

    default public boolean isCurrentInstanceMatchingTarget(String target, String appName, String currentInstance, List<String> referencedTargets) {
        if (target == null || currentInstance == null) {
            return false;
        }
        List<Object> targets = new ArrayList<String>();
        if (!target.equals("domain")) {
            targets.add(target);
        } else {
            if (referencedTargets == null) {
                referencedTargets = this.getAllReferencedTargetsForApplication(appName);
            }
            targets = referencedTargets;
        }
        for (String string : targets) {
            if (currentInstance.equals(string)) {
                return true;
            }
            Cluster cluster = this.getClusterNamed(string);
            if (cluster == null) continue;
            for (Server server : cluster.getInstances()) {
                if (!server.getName().equals(currentInstance)) continue;
                return true;
            }
        }
        return false;
    }

    default public List<Server> getServersInTarget(String target) {
        ArrayList<Server> servers = new ArrayList<Server>();
        Server server = this.getServerNamed(target);
        if (server != null) {
            servers.add(server);
        } else {
            Cluster cluster = this.getClusterNamed(target);
            if (cluster != null) {
                servers.addAll(cluster.getInstances());
            }
        }
        return servers;
    }

    default public List<ApplicationRef> getApplicationRefsInTarget(String target) {
        return this.getApplicationRefsInTarget(target, false);
    }

    default public List<ApplicationRef> getApplicationRefsInTarget(String target, boolean includeInstances) {
        ArrayList<ApplicationRef> allAppRefs = new ArrayList<ApplicationRef>();
        for (String tgt : this.getTargets(target)) {
            Server server = this.getServerNamed(tgt);
            if (server != null) {
                allAppRefs.addAll(server.getApplicationRef());
                continue;
            }
            Cluster cluster = this.getClusterNamed(tgt);
            if (cluster == null) continue;
            allAppRefs.addAll(cluster.getApplicationRef());
            if (!includeInstances) continue;
            for (Server srv : cluster.getInstances()) {
                allAppRefs.addAll(srv.getApplicationRef());
            }
        }
        return allAppRefs;
    }

    default public ApplicationRef getApplicationRefInTarget(String appName, String target) {
        for (ApplicationRef ref : this.getApplicationRefsInTarget(target)) {
            if (!ref.getRef().equals(appName)) continue;
            return ref;
        }
        return null;
    }

    default public ApplicationRef getApplicationRefInTarget(String appName, String target, boolean includeInstances) {
        for (ApplicationRef appRef : this.getApplicationRefsInTarget(target, includeInstances)) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef;
        }
        return null;
    }

    default public boolean isAppRefEnabledInTarget(String appName, String target) {
        ApplicationRef clusterRef;
        boolean found = false;
        Cluster containingCluster = this.getClusterForInstance(target);
        if (!(containingCluster == null || (clusterRef = this.getApplicationRefInTarget(appName, containingCluster.getName())) != null && Boolean.parseBoolean(clusterRef.getEnabled()))) {
            return false;
        }
        for (ApplicationRef ref : this.getApplicationRefsInTarget(target, true)) {
            if (!ref.getRef().equals(appName)) continue;
            found = true;
            if (Boolean.parseBoolean(ref.getEnabled())) continue;
            return false;
        }
        return found;
    }

    default public boolean isAppEnabledInTarget(String appName, String target) {
        Application application = this.getApplications().getApplication(appName);
        if (application != null && Boolean.parseBoolean(application.getEnabled())) {
            List<Object> targets = new ArrayList<String>();
            if (!target.equals("domain")) {
                targets.add(target);
            } else {
                targets = this.getAllReferencedTargetsForApplication(appName);
            }
            for (String string : targets) {
                if (this.isAppRefEnabledInTarget(appName, string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public boolean isAppReferencedByPaaSTarget(String appName) {
        for (String target : this.getAllReferencedTargetsForApplication(appName)) {
            Cluster cluster = this.getClusterNamed(target);
            if (cluster == null || !cluster.isVirtual()) continue;
            return true;
        }
        return false;
    }

    default public List<String> getAllReferencedTargetsForApplication(String appName) {
        ArrayList<String> referencedTargets = new ArrayList<String>();
        for (String target : this.getAllTargets()) {
            if (this.getApplicationRefInTarget(appName, target) == null) continue;
            referencedTargets.add(target);
        }
        return referencedTargets;
    }

    default public List<String> getAllTargets() {
        ArrayList<String> targets = new ArrayList<String>();
        for (Server server : this.getServers().getServer()) {
            if (server.getCluster() != null) continue;
            targets.add(server.getName());
        }
        Clusters clusters = this.getClusters();
        if (clusters != null) {
            for (Cluster cluster : clusters.getCluster()) {
                targets.add(cluster.getName());
            }
        }
        return targets;
    }

    default public List<String> getTargets(String target) {
        ArrayList<String> targets = new ArrayList<String>();
        if (!target.equals("domain")) {
            targets.add(target);
        } else {
            targets = this.getAllTargets();
        }
        return targets;
    }

    default public List<Application> getApplicationsInTarget(String target) {
        if (target.equals("domain")) {
            return this.getApplications().getApplications();
        }
        ArrayList<Application> apps = new ArrayList<Application>();
        for (ApplicationRef ref : this.getApplicationRefsInTarget(target)) {
            Application app = this.getApplications().getApplication(ref.getRef());
            if (app == null) continue;
            apps.add(app);
        }
        return apps;
    }

    default public String getVirtualServersForApplication(String target, String appName) {
        ApplicationRef appRef = this.getApplicationRefInTarget(appName, target);
        if (appRef != null) {
            return appRef.getVirtualServers();
        }
        return null;
    }

    default public String getEnabledForApplication(String target, String appName) {
        ApplicationRef appRef = this.getApplicationRefInTarget(appName, target);
        if (appRef != null) {
            return appRef.getEnabled();
        }
        return null;
    }

    default public ReferenceContainer getReferenceContainerNamed(String containerName) {
        Cluster cluster = this.getClusterNamed(containerName);
        if (cluster != null) {
            return cluster;
        }
        return this.getServerNamed(containerName);
    }

    default public Cluster getClusterForInstance(String instanceName) {
        for (Cluster cluster : this.getClusters().getCluster()) {
            for (ServerRef serverRef : cluster.getServerRef()) {
                if (!serverRef.getRef().equals(instanceName)) continue;
                return cluster;
            }
        }
        return null;
    }

    default public List<ReferenceContainer> getAllReferenceContainers() {
        LinkedList<ReferenceContainer> referenceContainers = new LinkedList<ReferenceContainer>(this.getServers().getServer());
        if (this.getClusters() != null) {
            referenceContainers.addAll(this.getClusters().getCluster());
        }
        return referenceContainers;
    }

    default public List<ReferenceContainer> getReferenceContainersOf(Config config) {
        LinkedList<ReferenceContainer> referenceContainers = new LinkedList<ReferenceContainer>();
        String configName = null;
        if (config != null) {
            configName = config.getName();
        }
        if (!StringUtils.ok(configName)) {
            return referenceContainers;
        }
        for (ReferenceContainer referenceContainer : this.getAllReferenceContainers()) {
            if (!configName.equals(referenceContainer.getReference())) continue;
            referenceContainers.add(referenceContainer);
        }
        return referenceContainers;
    }

    default public List<Server> getInstancesOnNode(String nodeName) {
        LinkedList<Server> servers = new LinkedList<Server>();
        try {
            if (!StringUtils.ok((String)nodeName)) {
                return servers;
            }
            for (Server server : this.getServers().getServer()) {
                if (!nodeName.equals(server.getNodeRef())) continue;
                servers.add(server);
            }
        }
        catch (Exception e) {
            ConfigApiLoggerInfo.getLogger().log(Level.WARNING, "NCLS-CFGAPI-00008", e.getLocalizedMessage());
        }
        return servers;
    }

    default public List<Cluster> getClustersOnNode(String nodeName) {
        HashMap<String, Cluster> clusters = new HashMap<String, Cluster>();
        try {
            for (Server server : this.getInstancesOnNode(nodeName)) {
                Cluster cluster = server.getCluster();
                if (!nodeName.equals(server.getNodeRef())) continue;
                clusters.put(cluster.getName(), cluster);
            }
        }
        catch (Exception e) {
            ConfigApiLoggerInfo.getLogger().log(Level.WARNING, "NCLS-CFGAPI-00007", e.getLocalizedMessage());
        }
        return new ArrayList<Cluster>(clusters.values());
    }

    @ConfigExtensionMethod
    public <T extends DomainExtension> T getExtensionByType(Class<T> var1);

    default public <P extends ConfigBeanProxy> boolean checkIfExtensionExists(Class<P> configBeanType) {
        for (DomainExtension extension : this.getExtensions()) {
            try {
                configBeanType.cast(extension);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

