/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.glassfish.api.admin.CommandException;

public final class DerbyControl {
    public static final String DB_LOG_FILENAME = "derby.log";
    private final String derbyCommand;
    private final String derbyHost;
    private final String derbyPort;
    private final String derbyHome;
    private final boolean redirect;
    private final String derbyUser;
    private final String derbyPassword;

    public DerbyControl(String dc, String dht, String dp, String redirect, String dhe, String duser, String dpwd) {
        this.derbyCommand = dc;
        this.derbyHost = dht;
        this.derbyPort = dp;
        this.derbyHome = dhe;
        this.redirect = Boolean.valueOf(redirect);
        this.derbyUser = duser;
        this.derbyPassword = dpwd;
        if (this.redirect) {
            try {
                String dbLog = "";
                dbLog = this.derbyHome == null ? this.createTempLogFile() : this.createDBLog(this.derbyHome);
                try (PrintStream printStream = new PrintStream(new FileOutputStream(dbLog, true), true);){
                    System.setOut(printStream);
                    System.setErr(printStream);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Runtime.getRuntime().exit(2);
            }
        }
        if (this.derbyHome != null && this.derbyHome.length() > 0) {
            System.setProperty("derby.system.home", this.derbyHome);
        }
        System.setProperty("derby.infolog.append", "true");
    }

    public DerbyControl(String dc, String dht, String dp) {
        this(dc, dht, dp, "true", null, null, null);
    }

    public DerbyControl(String dc, String dht, String dp, String redirect) {
        this(dc, dht, dp, redirect, null, null, null);
    }

    public DerbyControl(String dc, String dht, String dp, String redirect, String dhe) {
        this(dc, dht, dp, redirect, dhe, null, null);
    }

    public DerbyControl(String dc, String dht, String dp, String redirect, String duser, String dpassword) {
        this(dc, dht, dp, redirect, null, duser, dpassword);
    }

    private void invokeNetworkServerControl() {
        try {
            Class<?> networkServer = Class.forName("org.apache.derby.drda.NetworkServerControl");
            Method networkServerMethod = networkServer.getDeclaredMethod("main", String[].class);
            Object[] paramObj = null;
            paramObj = this.derbyUser == null && this.derbyPassword == null ? new Object[]{new String[]{this.derbyCommand, "-h", this.derbyHost, "-p", this.derbyPort}} : new Object[]{new String[]{this.derbyCommand, "-h", this.derbyHost, "-p", this.derbyPort, "-user", this.derbyUser, "-password", this.derbyPassword}};
            networkServerMethod.invoke(networkServer, paramObj);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Runtime.getRuntime().exit(2);
        }
    }

    private String createDBLog(String dbHome) throws Exception {
        File fDBHome = new File(dbHome);
        String dbLogFileName = "";
        StringManager lsm = StringManager.getManager(DerbyControl.class);
        if (fDBHome.isDirectory() && fDBHome.canWrite()) {
            File fDBLog = new File(dbHome, DB_LOG_FILENAME);
            dbLogFileName = fDBLog.toString();
            if (fDBLog.exists() && !fDBLog.canWrite()) {
                System.out.println(lsm.getString("UnableToAccessDatabaseLog", (Object)dbLogFileName));
                System.out.println(lsm.getString("ContinueStartingDatabase"));
                dbLogFileName = this.createTempLogFile();
            } else if (!fDBLog.exists() && !fDBLog.createNewFile()) {
                System.out.println(lsm.getString("UnableToCreateDatabaseLog", (Object)dbLogFileName));
            }
        } else {
            System.out.println(lsm.getString("InvalidDBDirectory", (Object)dbHome));
            System.out.println(lsm.getString("ContinueStartingDatabase"));
            dbLogFileName = this.createTempLogFile();
        }
        return dbLogFileName;
    }

    private String createTempLogFile() throws CommandException {
        String tempFileName = "";
        try {
            File fTemp = File.createTempFile("foo", null);
            fTemp.deleteOnExit();
            tempFileName = fTemp.toString();
        }
        catch (IOException ioe) {
            StringManager lsm = StringManager.getManager(DerbyControl.class);
            throw new CommandException(lsm.getString("UnableToAccessDatabaseLog", (Object)tempFileName));
        }
        return tempFileName;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("paramters not specified.");
            System.out.println("DerbyControl <derby command> <derby host> <derby port> <derby home> <redirect output>");
            System.exit(1);
        }
        DerbyControl derbyControl = null;
        derbyControl = args.length == 3 ? new DerbyControl(args[0], args[1], args[2]) : (args.length == 4 ? new DerbyControl(args[0], args[1], args[2], args[3]) : (args.length == 5 ? new DerbyControl(args[0], args[1], args[2], args[3], args[4]) : new DerbyControl(args[0], args[1], args[2], args[3], args[4], args[5])));
        derbyControl.invokeNetworkServerControl();
    }
}

