/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.cache.DataProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.jvnet.hk2.annotations.Service;

@Service
public class CommandModelDataProvider
implements DataProvider {
    private static final String ADDEDUPLOADOPTIONS_ELEMENT = "added-upload-options";
    private static final String ALIAS_ELEMENT = "alias";
    private static final String CLASS_ELEMENT = "class";
    private static final String DEFAULT_VALUE_ELEMENT = "default-value";
    private static final String PROMPT_ELEMENT = "prompt";
    private static final String PROMPT_AGAIN_ELEMENT = "prompt-again";
    private static final String ETAG_ELEMENT = "e-tag";
    private static final String NAME_ELEMENT = "name";
    private static final String OBSOLETE_ELEMENT = "obsolete";
    private static final String OPTIONAL_ELEMENT = "optional";
    private static final String PARAMETERS_ELEMENT = "parameters";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String PASSWORD_ELEMENT = "password";
    private static final String SHORTNAME_ELEMENT = "short-name";
    private static final String UNKNOWN_ARE_OPERANDS_ELEMENT = "unknown-are-operands";
    private static final String ROOT_ELEMENT = "command-model";
    private static final String PRIMARY_ELEMENT = "primary";
    private static final String MULTIPLE_ELEMENT = "multiple";
    private static final String USAGE_ELEMENT = "usage";
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private Charset charset;

    public CommandModelDataProvider() {
        try {
            this.charset = Charset.forName("UTF-8");
        }
        catch (Exception ex) {
            this.charset = Charset.defaultCharset();
        }
    }

    @Override
    public boolean accept(Class clazz) {
        return clazz == CommandModel.class || clazz == CachedCommandModel.class || clazz == CommandModelData.class;
    }

    @Override
    public void writeToStream(Object o, OutputStream stream) throws IOException {
        if (o == null) {
            return;
        }
        this.writeToStreamSimpleFormat((CommandModel)o, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStreamSimpleFormat(CommandModel cm, OutputStream stream) throws IOException {
        if (cm == null) {
            return;
        }
        BufferedWriter bw = null;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(stream, this.charset);
            bw = new BufferedWriter(writer);
            String str = cm.getCommandName();
            if (str != null && !str.isEmpty()) {
                bw.write(ROOT_ELEMENT);
                bw.write(": ");
                bw.write(str);
                bw.newLine();
            }
            bw.write(ETAG_ELEMENT);
            bw.write(": ");
            bw.write(CachedCommandModel.computeETag(cm));
            bw.newLine();
            if (cm.unknownOptionsAreOperands()) {
                bw.write(UNKNOWN_ARE_OPERANDS_ELEMENT);
                bw.write(": true");
                bw.newLine();
            }
            if (cm instanceof CachedCommandModel) {
                CachedCommandModel ccm = (CachedCommandModel)cm;
                if (ccm.isAddedUploadOption()) {
                    bw.write(ADDEDUPLOADOPTIONS_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if ((str = ccm.getUsage()) != null && !str.isEmpty()) {
                    bw.write(USAGE_ELEMENT);
                    bw.write(": ");
                    bw.write(this.escapeEndLines(str));
                    bw.newLine();
                }
            }
            for (CommandModel.ParamModel paramModel : cm.getParameters()) {
                Param param;
                bw.newLine();
                bw.write(NAME_ELEMENT);
                bw.write(": ");
                bw.write(paramModel.getName());
                bw.newLine();
                if (paramModel.getType() != null) {
                    bw.write(CLASS_ELEMENT);
                    bw.write(": ");
                    bw.write(paramModel.getType().getName());
                    bw.newLine();
                }
                if ((str = (param = paramModel.getParam()).shortName()) != null && !str.isEmpty()) {
                    bw.write(SHORTNAME_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if ((str = param.alias()) != null && !str.isEmpty()) {
                    bw.write(ALIAS_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if (param.optional()) {
                    bw.write(OPTIONAL_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.obsolete()) {
                    bw.write(OBSOLETE_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if ((str = param.defaultValue()) != null && !str.isEmpty()) {
                    bw.write(DEFAULT_VALUE_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if (param.primary()) {
                    bw.write(PRIMARY_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.multiple()) {
                    bw.write(MULTIPLE_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.password()) {
                    bw.write(PASSWORD_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (!(paramModel instanceof CommandModelData.ParamModelData)) continue;
                str = ((CommandModelData.ParamModelData)paramModel).getPrompt();
                if (str != null && !str.isEmpty()) {
                    bw.write(PROMPT_ELEMENT);
                    bw.write(": ");
                    bw.write(this.escapeEndLines(str));
                    bw.newLine();
                }
                if ((str = ((CommandModelData.ParamModelData)paramModel).getPromptAgain()) == null || str.isEmpty()) continue;
                bw.write(PROMPT_AGAIN_ELEMENT);
                bw.write(": ");
                bw.write(this.escapeEndLines(str));
                bw.newLine();
            }
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception ex) {}
            try {
                writer.close();
            }
            catch (Exception ex) {}
        }
    }

    private String escapeEndLines(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("\n", "${NL}").replace("\r", "${RC}");
    }

    private String resolveEndLines(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("${NL}", "\n").replace("${RC}", "\r");
    }

    @Override
    public Object toInstance(InputStream stream, Class clazz) throws IOException {
        return this.toInstanceSimpleFormat(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandModel toInstanceSimpleFormat(InputStream stream) throws IOException {
        CachedCommandModel result = null;
        InputStreamReader isr = null;
        BufferedReader r = null;
        boolean inParam = false;
        String name = null;
        String eTag = null;
        boolean unknownAreOperands = false;
        String usage = null;
        boolean addedUploadOption = false;
        String pName = null;
        Class<?> pCls = null;
        boolean pOptional = false;
        String pDefaultValue = null;
        String pShortName = null;
        boolean pObsolete = false;
        String pAlias = null;
        boolean pPrimary = false;
        boolean pMultiple = false;
        boolean pPassword = false;
        String pPrompt = null;
        String pPromptAgain = null;
        try {
            String line;
            isr = new InputStreamReader(stream, this.charset);
            r = new BufferedReader(isr);
            while ((line = r.readLine()) != null) {
                int ind = line.indexOf(58);
                if (ind <= 0) continue;
                String key = line.substring(0, ind);
                String value = line.substring(ind + 1).trim();
                if (inParam) {
                    if (NAME_ELEMENT.equals(key)) {
                        CommandModelData.ParamModelData pmd = new CommandModelData.ParamModelData(pName, pCls, pOptional, pDefaultValue, pShortName, pObsolete, pAlias);
                        pmd.param._primary = pPrimary;
                        pmd.param._multiple = pMultiple;
                        pmd.param._password = pPassword;
                        pmd.prompt = pPrompt;
                        pmd.promptAgain = pPromptAgain;
                        result.add(pmd);
                        pCls = null;
                        pOptional = false;
                        pDefaultValue = null;
                        pShortName = null;
                        pObsolete = false;
                        pAlias = null;
                        pPrimary = false;
                        pMultiple = false;
                        pPassword = false;
                        pPrompt = null;
                        pPromptAgain = null;
                        pName = value;
                        continue;
                    }
                    if (CLASS_ELEMENT.equals(key)) {
                        if (value.isEmpty()) continue;
                        try {
                            pCls = Class.forName(value);
                        }
                        catch (Exception ex) {}
                        continue;
                    }
                    if (OPTIONAL_ELEMENT.equals(key)) {
                        pOptional = value.startsWith("t");
                        continue;
                    }
                    if (DEFAULT_VALUE_ELEMENT.equals(key)) {
                        pDefaultValue = value;
                        continue;
                    }
                    if (SHORTNAME_ELEMENT.equals(key)) {
                        pShortName = value;
                        continue;
                    }
                    if (OBSOLETE_ELEMENT.equals(key)) {
                        pObsolete = value.startsWith("t");
                        continue;
                    }
                    if (ALIAS_ELEMENT.equals(key)) {
                        pAlias = value;
                        continue;
                    }
                    if (PRIMARY_ELEMENT.equals(key)) {
                        pPrimary = value.startsWith("t");
                        continue;
                    }
                    if (MULTIPLE_ELEMENT.equals(key)) {
                        pMultiple = value.startsWith("t");
                        continue;
                    }
                    if (PASSWORD_ELEMENT.equals(key)) {
                        pPassword = value.startsWith("t");
                        continue;
                    }
                    if (PROMPT_ELEMENT.equals(key)) {
                        pPrompt = this.resolveEndLines(value);
                        continue;
                    }
                    if (!PROMPT_AGAIN_ELEMENT.equals(key)) continue;
                    pPromptAgain = this.resolveEndLines(value);
                    continue;
                }
                if (ROOT_ELEMENT.equals(key)) {
                    name = value;
                    continue;
                }
                if (ETAG_ELEMENT.equals(key)) {
                    eTag = value;
                    continue;
                }
                if (UNKNOWN_ARE_OPERANDS_ELEMENT.equals(key)) {
                    unknownAreOperands = value.startsWith("t");
                    continue;
                }
                if (ADDEDUPLOADOPTIONS_ELEMENT.equals(key)) {
                    addedUploadOption = value.startsWith("t");
                    continue;
                }
                if (USAGE_ELEMENT.equals(key)) {
                    usage = this.resolveEndLines(value);
                    continue;
                }
                if (!NAME_ELEMENT.equals(key)) continue;
                result = new CachedCommandModel(name, eTag);
                result.dashOk = unknownAreOperands;
                result.setUsage(usage);
                result.setAddedUploadOption(addedUploadOption);
                inParam = true;
                pName = value;
            }
            if (inParam) {
                CommandModelData.ParamModelData pmd = new CommandModelData.ParamModelData(pName, pCls, pOptional, pDefaultValue, pShortName, pObsolete, pAlias);
                pmd.param._primary = pPrimary;
                pmd.param._multiple = pMultiple;
                pmd.param._password = pPassword;
                pmd.prompt = pPrompt;
                pmd.promptAgain = pPromptAgain;
                result.add(pmd);
            } else if (result == null && name != null && !name.isEmpty()) {
                result = new CachedCommandModel(name, eTag);
                result.dashOk = unknownAreOperands;
                result.setUsage(usage);
                result.setAddedUploadOption(addedUploadOption);
            }
        }
        finally {
            try {
                r.close();
            }
            catch (Exception ex) {}
            try {
                isr.close();
            }
            catch (Exception ex) {}
        }
        return result;
    }
}

