/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sysprops.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.glassfish.jersey.examples.sysprops.PropertyResource;

public class PropertyResourceImpl
implements PropertyResource {
    private final String name;
    private final UriInfo uriInfo;

    public PropertyResourceImpl(String name, UriInfo uriInfo) {
        this.name = name;
        this.uriInfo = uriInfo;
    }

    @Override
    public String get() {
        String value = System.getProperty(this.name);
        if (value == null) {
            throw new WebApplicationException(404);
        }
        return value;
    }

    @Override
    public String set(String value) {
        if (System.setProperty(this.name, value) == null) {
            throw new WebApplicationException(Response.created((URI)this.uriInfo.getRequestUri()).entity((Object)value).build());
        }
        return value;
    }
}

