/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httppatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class PatchingInterceptor
implements ReaderInterceptor {
    private final UriInfo uriInfo;
    private final MessageBodyWorkers workers;

    public PatchingInterceptor(@Context UriInfo uriInfo, @Context MessageBodyWorkers workers) {
        this.uriInfo = uriInfo;
        this.workers = workers;
    }

    public Object aroundReadFrom(ReaderInterceptorContext readerInterceptorContext) throws IOException, WebApplicationException {
        Object bean;
        Object resource = this.uriInfo.getMatchedResources().get(0);
        Method found = null;
        for (Method next : resource.getClass().getMethods()) {
            if (next.getAnnotation(GET.class) == null) continue;
            found = next;
            break;
        }
        if (found == null) {
            throw new InternalServerErrorException("No matching GET method on resource");
        }
        try {
            bean = found.invoke(resource, new Object[0]);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MessageBodyWriter bodyWriter = this.workers.getMessageBodyWriter(bean.getClass(), bean.getClass(), new Annotation[0], MediaType.APPLICATION_JSON_TYPE);
        bodyWriter.writeTo(bean, bean.getClass(), bean.getClass(), new Annotation[0], MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedHashMap(), (OutputStream)baos);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode serverState = (JsonNode)mapper.readValue(baos.toByteArray(), JsonNode.class);
        JsonNode patchAsNode = (JsonNode)mapper.readValue(readerInterceptorContext.getInputStream(), JsonNode.class);
        JsonPatch patch = JsonPatch.fromJson((JsonNode)patchAsNode);
        try {
            JsonNode result = patch.apply(serverState);
            ByteArrayOutputStream resultAsByteArray = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)resultAsByteArray, (Object)result);
            readerInterceptorContext.setInputStream((InputStream)new ByteArrayInputStream(resultAsByteArray.toByteArray()));
            return readerInterceptorContext.proceed();
        }
        catch (JsonPatchException ex) {
            throw new InternalServerErrorException("Error applying patch.", (Throwable)ex);
        }
    }
}

