/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httppatch;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.httppatch.OptionsAcceptPatchHeaderFilter;
import org.glassfish.jersey.examples.httppatch.PatchableResource;
import org.glassfish.jersey.examples.httppatch.PatchingInterceptor;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.moxy.json.MoxyJsonConfig;
import org.glassfish.jersey.server.ResourceConfig;

public final class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/http-patch");
    static final String ROOT_PATH = "patchable-state";

    private App() {
    }

    public static void main(String[] args) {
        try {
            System.out.println("Jersey HTTP PATCH Support Example App");
            final HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create(), (boolean)false);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.shutdownNow();
                }
            }));
            server.start();
            System.out.println(String.format("Application started.\nTry out %s/%s\nStop the application using CTRL+C", BASE_URI, ROOT_PATH));
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig create() {
        ResourceConfig app = new ResourceConfig(new Class[]{PatchableResource.class, OptionsAcceptPatchHeaderFilter.class, PatchingInterceptor.class});
        app.register(App.createMoxyJsonResolver());
        app.property("jersey.config.server.tracing.type", (Object)"ON_DEMAND");
        return app;
    }

    public static ContextResolver<MoxyJsonConfig> createMoxyJsonResolver() {
        MoxyJsonConfig moxyJsonConfig = new MoxyJsonConfig().setFormattedOutput(true).setNamespaceSeparator(':');
        return moxyJsonConfig.resolver();
    }
}

