/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

public class Exceptions {

    @Provider
    public static class WebApplicationExceptionMapper
    implements ExceptionMapper<WebApplicationException> {
        public Response toResponse(WebApplicationException exception) {
            Response r = exception.getResponse();
            return Response.status((int)r.getStatus()).entity((Object)("Code:" + r.getStatus() + ":" + this.getClass().getSimpleName())).build();
        }
    }

    @Provider
    public static class MySubExceptionMapper
    implements ExceptionMapper<MySubException> {
        public Response toResponse(MySubException exception) {
            Response r = exception.getResponse();
            return Response.status((int)r.getStatus()).entity((Object)("Code:" + r.getStatus() + ":" + this.getClass().getSimpleName())).build();
        }
    }

    @Provider
    public static class MyExceptionMapper
    implements ExceptionMapper<MyException> {
        public Response toResponse(MyException exception) {
            Response r = exception.getResponse();
            return Response.status((int)r.getStatus()).entity((Object)("Code:" + r.getStatus() + ":" + this.getClass().getSimpleName())).build();
        }
    }

    public static class MySubSubException
    extends MySubException {
        public MySubSubException(Response response) {
            super(response);
        }
    }

    public static class MySubException
    extends MyException {
        public MySubException(Response response) {
            super(response);
        }
    }

    public static class MyException
    extends RuntimeException {
        private Response response;

        public MyException(Response response) {
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }
    }
}

