/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.operations.application.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.examples.operations.application.BankingService;
import org.glassfish.examples.operations.application.DepositorService;
import org.glassfish.examples.operations.application.TransferService;
import org.glassfish.examples.operations.application.WithdrawalService;
import org.glassfish.examples.operations.application.internal.DepositScopeImpl;
import org.glassfish.examples.operations.application.internal.WithdrawalScopeImpl;
import org.glassfish.examples.operations.scopes.DepositScope;
import org.glassfish.examples.operations.scopes.WithdrawalScope;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationManager;

@Singleton
public class BankingServiceImpl
implements BankingService {
    @Inject
    private OperationManager manager;
    @Inject
    private TransferService transferAgent;
    @Inject
    private DepositorService depositorAgent;
    @Inject
    private WithdrawalService withdrawerAgent;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, OperationHandle<DepositScope>> depositors = new HashMap<String, OperationHandle<DepositScope>>();
    private final Map<String, OperationHandle<WithdrawalScope>> withdrawers = new HashMap<String, OperationHandle<WithdrawalScope>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationHandle<DepositScope> getDepositBankHandle(String bank) {
        this.lock.lock();
        try {
            OperationHandle depositor = this.depositors.get(bank);
            if (depositor == null) {
                depositor = this.manager.createOperation((Annotation)DepositScopeImpl.INSTANCE);
                this.depositors.put(bank, (OperationHandle<DepositScope>)depositor);
            }
            OperationHandle operationHandle = depositor;
            return operationHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationHandle<WithdrawalScope> getWithdrawerBankHandle(String bank) {
        this.lock.lock();
        try {
            OperationHandle withdrawer = this.withdrawers.get(bank);
            if (withdrawer == null) {
                withdrawer = this.manager.createOperation((Annotation)WithdrawalScopeImpl.INSTANCE);
                this.withdrawers.put(bank, (OperationHandle<WithdrawalScope>)withdrawer);
            }
            OperationHandle operationHandle = withdrawer;
            return operationHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transferFunds(String withdrawlBank, long withdrawlAccount, String depositorBank, long depositAccount, int funds) {
        this.lock.lock();
        try {
            int n;
            OperationHandle<DepositScope> depositor = this.getDepositBankHandle(depositorBank);
            OperationHandle<WithdrawalScope> withdrawer = this.getWithdrawerBankHandle(withdrawlBank);
            depositor.resume();
            withdrawer.resume();
            try {
                n = this.transferAgent.doTransfer(depositAccount, withdrawlAccount, funds);
            }
            catch (Throwable throwable) {
                withdrawer.suspend();
                depositor.suspend();
                throw throwable;
            }
            withdrawer.suspend();
            depositor.suspend();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDepositedBalance(String bank, long account) {
        OperationHandle<DepositScope> depositor = this.getDepositBankHandle(bank);
        depositor.resume();
        try {
            int n = this.depositorAgent.getBalance(account);
            return n;
        }
        finally {
            depositor.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWithdrawalBalance(String bank, long account) {
        OperationHandle<WithdrawalScope> withdrawer = this.getWithdrawerBankHandle(bank);
        withdrawer.resume();
        try {
            int n = this.withdrawerAgent.getBalance(account);
            return n;
        }
        finally {
            withdrawer.suspend();
        }
    }
}

