/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.apf.ComponentInfo;
import org.glassfish.apf.factory.Factory;

public class ComponentDefinition
implements ComponentInfo {
    private final Class clazz;
    private final List<Constructor> constructors = new ArrayList<Constructor>();
    private final List<Class> classes = new ArrayList<Class>();
    private final List<Field> fields = new ArrayList<Field>();
    private final Map<MethodKey, Method> methodMap = new HashMap<MethodKey, Method>();

    public ComponentDefinition(Class clazz) {
        this.clazz = clazz;
        this.constructClassList();
        this.initializeConstructors();
        this.initializeFields();
        this.initializeMethods();
    }

    public Field[] getFields() {
        return this.fields.toArray(new Field[this.fields.size()]);
    }

    public Method[] getMethods() {
        return this.methodMap.values().toArray(new Method[this.methodMap.size()]);
    }

    public Constructor[] getConstructors() {
        return this.constructors.toArray(new Constructor[this.constructors.size()]);
    }

    private void constructClassList() {
        if (!Factory.isSkipAnnotationProcessing(this.clazz.getName())) {
            this.classes.add(this.clazz);
        }
        Class parent = this.clazz;
        while ((parent = parent.getSuperclass()) != null) {
            if (parent.getPackage() != null && parent.getPackage().getName().startsWith("java.lang") || Factory.isSkipAnnotationProcessing(parent.getName())) continue;
            this.classes.add(0, parent);
        }
    }

    private void initializeConstructors() {
        for (Class cl : this.classes) {
            for (Constructor<?> constr : cl.getConstructors()) {
                this.constructors.add(constr);
            }
        }
    }

    private void initializeFields() {
        for (Class cl : this.classes) {
            for (Field f : cl.getDeclaredFields()) {
                this.fields.add(f);
            }
        }
    }

    private void initializeMethods() {
        for (Class cl : this.classes) {
            for (Method method : cl.getDeclaredMethods()) {
                if (method.isBridge()) continue;
                this.methodMap.put(new MethodKey(method), method);
            }
        }
    }

    private class MethodKey {
        private Method m = null;
        private int hashCode;
        private String className = null;
        private Package classPackage = null;

        private MethodKey(Method m) {
            this.m = m;
            this.hashCode = m.getName().hashCode();
            this.className = m.getDeclaringClass().getName();
            this.classPackage = m.getDeclaringClass().getPackage();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey mk2 = (MethodKey)o;
            Method m2 = mk2.m;
            if (this.m.getName().equals(m2.getName()) && Arrays.equals(this.m.getParameterTypes(), m2.getParameterTypes())) {
                boolean isSamePackage;
                int modifiers = this.m.getModifiers();
                int modifiers2 = m2.getModifiers();
                boolean isPackageProtected2 = !Modifier.isPublic(modifiers2) && !Modifier.isProtected(modifiers2) && !Modifier.isPrivate(modifiers2);
                boolean bl = isSamePackage = this.classPackage == null && mk2.classPackage == null || this.classPackage != null && mk2.classPackage != null && this.classPackage.getName().equals(mk2.classPackage.getName());
                if (Modifier.isPrivate(modifiers)) {
                    return Modifier.isPrivate(modifiers2) && isSamePackage && this.className.equals(mk2.className);
                }
                return Modifier.isPublic(modifiers2) || Modifier.isProtected(modifiers2) || isPackageProtected2 && isSamePackage;
            }
            return false;
        }
    }
}

