/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.util.HashMap;
import java.util.Map;

public enum SpecMode {
    JAVAEE("JavaEE", "javax."),
    JAKARTA("Jakarta", "jakarta.");

    public static final int COUNT;
    private static final Map<String, SpecMode> STR_TO_SPECMODE_MAP;
    private final String name;
    private final String prefix;

    public static SpecMode getSpecMode(String name) {
        if (name == null) {
            return JAVAEE;
        }
        SpecMode sm = STR_TO_SPECMODE_MAP.get(name.toLowerCase());
        return sm != null ? sm : JAVAEE;
    }

    private SpecMode(String modeName, String groupIdPrefix) {
        this.name = modeName;
        this.prefix = groupIdPrefix;
    }

    public String grePrefix() {
        return this.prefix;
    }

    static {
        COUNT = SpecMode.values().length;
        STR_TO_SPECMODE_MAP = new HashMap<String, SpecMode>(COUNT);
        for (SpecMode sm : SpecMode.values()) {
            STR_TO_SPECMODE_MAP.put(sm.name.toLowerCase(), sm);
        }
    }
}

