/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class Metadata {
    private String bundleSymbolicName;
    private String bundleSpecVersion;
    private String bundleVersion;
    private String jarExtensionName;
    private String jarSpecificationVersion;
    private String jarImplementationVersion;
    private Properties properties = null;
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String BUNDLE_SPEC_VERSION = "BundleSpecVersion";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String JAR_EXTENSION_NAME = "Extension-Name";
    public static final String JAR_SPECIFICATION_VERSION = "Specification-Version";
    public static final String JAR_IMPLEMENTATION_VERSION = "Implementation-Version";
    private List<String> errors = new LinkedList<String>();
    private static final String[] KEYS = new String[]{"Bundle-SymbolicName", "BundleSpecVersion", "Bundle-Version", "Extension-Name", "Specification-Version", "Implementation-Version"};

    Metadata(String _bundleSymbolicName, String _bundleSpecVersion, String _bundleVersion, String _jarExtensionName, String _jarSpecificationVersion, String _jarImplementationVersion) {
        this.bundleSymbolicName = _bundleSymbolicName != null ? _bundleSymbolicName : "";
        this.bundleSpecVersion = _bundleSpecVersion != null ? _bundleSpecVersion : "";
        this.bundleVersion = _bundleVersion != null ? _bundleVersion : "";
        this.jarExtensionName = _jarExtensionName != null ? _jarExtensionName : "";
        this.jarSpecificationVersion = _jarSpecificationVersion != null ? _jarSpecificationVersion : "";
        this.jarImplementationVersion = _jarImplementationVersion != null ? _jarImplementationVersion : "";
        this.properties = new Properties();
        this.properties.put("spec.bundle.symbolic-name", this.bundleSymbolicName);
        this.properties.put("spec.bundle.spec.version", this.bundleSpecVersion);
        this.properties.put("spec.bundle.version", this.bundleVersion);
        this.properties.put("spec.extension.name", this.jarExtensionName);
        this.properties.put("spec.specification.version", this.jarSpecificationVersion);
        this.properties.put("spec.implementation.version", this.jarImplementationVersion);
    }

    Metadata(String _bundleSymbolicName, String _bundleSpecVersion, String _bundleVersion, String _jarExtensionName, String _jarSpecificationVersion, String _jarImplementationVersion, List<String> _errors) {
        this(_bundleSymbolicName, _bundleSpecVersion, _bundleVersion, _jarExtensionName, _jarSpecificationVersion, _jarImplementationVersion);
        this.errors = _errors;
    }

    private static String getBundleSpecVersion(String headers) {
        HashMap<String, List> res = new HashMap<String, List>();
        String[] headersTokens = headers.split(";");
        if (headersTokens.length > 1) {
            ArrayList<String> curHeader = new ArrayList<String>();
            String key = "";
            for (int i = 0; i < headersTokens.length; ++i) {
                String[] lastToken;
                if (!headersTokens[i].startsWith("uses:=") && !headersTokens[i].startsWith("version=")) {
                    key = headersTokens[i];
                    continue;
                }
                if (headersTokens[i].startsWith("version=")) {
                    lastToken = headersTokens[i].split(",");
                    curHeader.add(lastToken[0]);
                    res.put(key, new ArrayList(curHeader));
                    if (headersTokens[i].length() <= lastToken[0].length()) continue;
                    key = headersTokens[i].substring(lastToken[0].length() + 1);
                    curHeader.clear();
                    continue;
                }
                if (!headersTokens[i].startsWith("uses:=")) continue;
                if (i != headersTokens.length - 1 && !headersTokens[i + 1].startsWith("version=")) {
                    lastToken = headersTokens[i].split(",");
                    curHeader.add(headersTokens[i].substring(0, headersTokens[i].length() - lastToken[lastToken.length - 1].length()));
                    res.put(key, new ArrayList(curHeader));
                    key = lastToken[lastToken.length - 1];
                    curHeader.clear();
                    continue;
                }
                curHeader.add(headersTokens[i]);
            }
        } else {
            res.put(headers, Collections.EMPTY_LIST);
        }
        return "";
    }

    public static Metadata fromJar(JarFile jar) throws IOException {
        ZipEntry e = jar.getEntry("META-INF/MANIFEST.MF");
        InputStream is = jar.getInputStream(e);
        Manifest manifest = new Manifest(is);
        LinkedList<String> errors = new LinkedList<String>();
        String[] mdata = new String[KEYS.length];
        for (int i = 0; i < KEYS.length; ++i) {
            if (KEYS[i].equals(BUNDLE_SPEC_VERSION)) continue;
            mdata[i] = manifest.getMainAttributes().getValue(KEYS[i]);
            if (mdata[i] != null) continue;
            errors.add("ERROR: " + KEYS[i] + " not found in MANIFEST");
        }
        return new Metadata(mdata[0], mdata[1], mdata[2], mdata[3], mdata[4], mdata[5], errors);
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleSpecVersion() {
        return this.bundleSpecVersion;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getJarExtensionName() {
        return this.jarExtensionName;
    }

    public String getJarSpecificationVersion() {
        return this.jarSpecificationVersion;
    }

    public String getjarImplementationVersion() {
        return this.jarImplementationVersion;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

