/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.models;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Variable;
import org.gitlab4j.models.utils.ISO8601;

public class GitLabForm {
    private Map<String, String> formValues = new LinkedHashMap<String, String>();

    public GitLabForm() {
    }

    public GitLabForm(int page, int perPage) {
        this.withParam("page", page);
        this.withParam("per_page", perPage);
    }

    public GitLabForm withParam(String name, Object value) throws IllegalArgumentException {
        return this.withParam(name, value, false);
    }

    public GitLabForm withParam(String name, Date date) throws IllegalArgumentException {
        return this.withParam(name, date, false);
    }

    public GitLabForm withParam(String name, Date date, boolean required) throws IllegalArgumentException {
        return this.withParam(name, date == null ? null : ISO8601.toString(date), required);
    }

    public GitLabForm withParam(String name, AccessLevel level) throws IllegalArgumentException {
        return this.withParam(name, level, false);
    }

    public GitLabForm withParam(String name, AccessLevel level, boolean required) throws IllegalArgumentException {
        return this.withParam(name, level == null ? null : level.toValue(), required);
    }

    public <T> GitLabForm withParam(String name, List<T> values) {
        return this.withParam(name, values, false);
    }

    public <T> GitLabForm withParam(String name, List<T> values, boolean required) throws IllegalArgumentException {
        if (values == null || values.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        for (T value : values) {
            if (value == null) continue;
            this.formValues.put(name + "[]", value.toString());
        }
        return this;
    }

    public GitLabForm withParam(String name, Map<String, ?> variables, boolean required) throws IllegalArgumentException {
        if (variables == null || variables.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        for (Map.Entry<String, ?> variable : variables.entrySet()) {
            Object value = variable.getValue();
            if (value == null) continue;
            this.formValues.put(name + "[" + variable.getKey() + "]", value.toString());
        }
        return this;
    }

    public GitLabForm withParam(String name, Object value, boolean required) throws IllegalArgumentException {
        if (value == null) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        String stringValue = value.toString();
        if (required && stringValue.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty or null");
        }
        this.formValues.put(name.trim(), stringValue);
        return this;
    }

    public GitLabForm withParam(List<Variable> variables) {
        if (variables == null || variables.isEmpty()) {
            return this;
        }
        variables.forEach(v -> {
            String value = v.getValue();
            if (value != null) {
                this.formValues.put("variables[" + v.getKey() + "]", value);
            }
        });
        return this;
    }

    public Map<String, String> getFormValues() {
        return this.formValues;
    }
}

