/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gitlab4j.models.utils.JacksonJson;
import org.gitlab4j.models.utils.JacksonJsonEnumHelper;

public class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String key;
    private String value;
    private Type variableType;
    @JsonProperty(value="protected")
    private Boolean isProtected;
    @JsonProperty(value="masked")
    private Boolean isMasked;
    private String environmentScope;

    public Variable() {
    }

    public Variable(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Type getVariableType() {
        return this.variableType;
    }

    public void setVariableType(Type variableType) {
        this.variableType = variableType;
    }

    public Boolean getProtected() {
        return this.isProtected;
    }

    public void setProtected(Boolean isProtected) {
        this.isProtected = isProtected;
    }

    public Boolean getMasked() {
        return this.isMasked;
    }

    public void setMasked(Boolean masked) {
        this.isMasked = masked;
    }

    public String getEnvironmentScope() {
        return this.environmentScope;
    }

    public void setEnvironmentScope(String environmentScope) {
        this.environmentScope = environmentScope;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }

    public static final List<Variable> convertMapToList(Map<String, String> variables) {
        if (variables == null) {
            return null;
        }
        ArrayList<Variable> varList = new ArrayList<Variable>(variables.size());
        variables.forEach((k, v) -> varList.add(new Variable((String)k, (String)v)));
        return varList;
    }

    public static enum Type {
        ENV_VAR,
        FILE;

        private static JacksonJsonEnumHelper<Type> enumHelper;

        @JsonCreator
        public static Type forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Type>(Type.class);
        }
    }
}

