/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import org.gitlab4j.api.utils.ISO8601;

public class HttpRequestUtils {
    public static String getShortRequestDump(String fromMethod, HttpServletRequest request) {
        return HttpRequestUtils.getShortRequestDump(fromMethod, false, request);
    }

    public static String getShortRequestDump(String fromMethod, boolean includeHeaders, HttpServletRequest request) {
        StringBuilder dump = new StringBuilder();
        dump.append("Timestamp     : ").append(ISO8601.getTimestamp()).append("\n");
        dump.append("fromMethod    : ").append(fromMethod).append("\n");
        dump.append("Method        : ").append(request.getMethod()).append('\n');
        dump.append("Scheme        : ").append(request.getScheme()).append('\n');
        dump.append("URI           : ").append(request.getRequestURI()).append('\n');
        dump.append("Query-String  : ").append(request.getQueryString()).append('\n');
        dump.append("Auth-Type     : ").append(request.getAuthType()).append('\n');
        dump.append("Remote-Addr   : ").append(request.getRemoteAddr()).append('\n');
        dump.append("Scheme        : ").append(request.getScheme()).append('\n');
        dump.append("Content-Type  : ").append(request.getContentType()).append('\n');
        dump.append("Content-Length: ").append(request.getContentLength()).append('\n');
        if (includeHeaders) {
            dump.append("Headers       :\n");
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                dump.append("\t").append(header).append(": ").append(request.getHeader(header)).append('\n');
            }
        }
        return dump.toString();
    }

    public static String getRequestDump(String fromMethod, HttpServletRequest request, boolean includePostData) {
        String shortDump = HttpRequestUtils.getShortRequestDump(fromMethod, request);
        StringBuilder buf = new StringBuilder(shortDump);
        try {
            buf.append("\nAttributes:\n");
            Enumeration attrs = request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String attr = (String)attrs.nextElement();
                buf.append("\t").append(attr).append(": ").append(request.getAttribute(attr)).append('\n');
            }
            buf.append("\nHeaders:\n");
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                buf.append("\t").append(header).append(": ").append(request.getHeader(header)).append('\n');
            }
            buf.append("\nParameters:\n");
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                buf.append("\t").append(param).append(": ").append(request.getParameter(param)).append('\n');
            }
            buf.append("\nCookies:\n");
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String cstr = "\t" + cookie.getDomain() + "." + cookie.getPath() + "." + cookie.getName() + ": " + cookie.getValue() + "\n";
                    buf.append(cstr);
                }
            }
            if (includePostData) {
                buf.append(HttpRequestUtils.getPostDataAsString(request)).append("\n");
            }
            return buf.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String getPostDataAsString(HttpServletRequest request) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");){
            String string = HttpRequestUtils.getReaderContentAsString(reader);
            return string;
        }
    }

    public static String getReaderContentAsString(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2048];
        StringBuilder out = new StringBuilder();
        while ((count = reader.read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, count);
        }
        return out.toString();
    }

    public static String maskPrivateToken(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.replaceAll("PRIVATE\\-TOKEN\\: [\\S]*", "PRIVATE-TOKEN: ********");
    }
}

