/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.AccessRequest;
import org.gitlab4j.api.models.ApprovalRule;
import org.gitlab4j.api.models.ApprovalRuleParams;
import org.gitlab4j.api.models.AuditEvent;
import org.gitlab4j.api.models.Badge;
import org.gitlab4j.api.models.CustomAttribute;
import org.gitlab4j.api.models.Event;
import org.gitlab4j.api.models.FileUpload;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Namespace;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectApprovalsConfig;
import org.gitlab4j.api.models.ProjectFetches;
import org.gitlab4j.api.models.ProjectFilter;
import org.gitlab4j.api.models.ProjectGroup;
import org.gitlab4j.api.models.ProjectGroupsFilter;
import org.gitlab4j.api.models.ProjectHook;
import org.gitlab4j.api.models.ProjectUser;
import org.gitlab4j.api.models.PushRules;
import org.gitlab4j.api.models.RemoteMirror;
import org.gitlab4j.api.models.Snippet;
import org.gitlab4j.api.models.Variable;
import org.gitlab4j.api.models.Visibility;
import org.gitlab4j.api.utils.ISO8601;

public class ProjectApi
extends AbstractApi
implements Constants {
    public ProjectApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public ProjectFetches getProjectStatistics(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "statistics");
        return (ProjectFetches)response.readEntity(ProjectFetches.class);
    }

    public Optional<ProjectFetches> getOptionalProjectStatistics(Object projectIdOrPath) {
        try {
            return Optional.ofNullable(this.getProjectStatistics(projectIdOrPath));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Project> getProjects() throws GitLabApiException {
        String url = this.gitLabApi.getGitLabServerUrl();
        if (url.startsWith("https://gitlab.com")) {
            GitLabApi.getLogger().warning("Fetching all projects from " + url + " may take many hours to complete, use Pager<Project> getProjects(int) instead.");
        }
        return this.getProjects(this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "projects");
    }

    public Stream<Project> getProjectsStream() throws GitLabApiException {
        return this.getProjects(this.getDefaultPerPage()).stream();
    }

    @Deprecated
    public List<Project> getProjects(Boolean archived, Visibility visibility, String orderBy, String sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics) throws GitLabApiException {
        Constants.ProjectOrderBy projectOrderBy = Constants.ProjectOrderBy.valueOf(orderBy);
        Constants.SortOrder sortOrder = Constants.SortOrder.valueOf(sort);
        return this.getProjects(archived, visibility, projectOrderBy, sortOrder, search, simple, owned, membership, starred, statistics, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(Boolean archived, Visibility visibility, Constants.ProjectOrderBy orderBy, Constants.SortOrder sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics) throws GitLabApiException {
        return this.getProjects(archived, visibility, orderBy, sort, search, simple, owned, membership, starred, statistics, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(Boolean archived, Visibility visibility, Constants.ProjectOrderBy orderBy, Constants.SortOrder sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("archived", archived).withParam("visibility", (Object)visibility).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("search", search).withParam("simple", simple).withParam("owned", owned).withParam("membership", membership).withParam("starred", starred).withParam("statistics", statistics).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(Boolean archived, Visibility visibility, Constants.ProjectOrderBy orderBy, Constants.SortOrder sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("archived", archived).withParam("visibility", (Object)visibility).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("search", search).withParam("simple", simple).withParam("owned", owned).withParam("membership", membership).withParam("starred", starred).withParam("statistics", statistics);
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public List<Project> getProjects(String search) throws GitLabApiException {
        return this.getProjects(search, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search);
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public Stream<Project> getProjectsStream(String search) throws GitLabApiException {
        return this.getProjects(search, this.getDefaultPerPage()).stream();
    }

    public List<Project> getMemberProjects() throws GitLabApiException {
        return this.getMemberProjects(this.getDefaultPerPage()).all();
    }

    public List<Project> getMemberProjects(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("membership", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getMemberProjects(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("membership", true);
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public Stream<Project> getMemberProjectsStream() throws GitLabApiException {
        return this.getMemberProjects(this.getDefaultPerPage()).stream();
    }

    public List<Project> getOwnedProjects() throws GitLabApiException {
        return this.getOwnedProjects(this.getDefaultPerPage()).all();
    }

    public List<Project> getOwnedProjects(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getOwnedProjects(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true);
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public Stream<Project> getOwnedProjectsStream() throws GitLabApiException {
        return this.getOwnedProjects(this.getDefaultPerPage()).stream();
    }

    public List<Project> getStarredProjects() throws GitLabApiException {
        return this.getStarredProjects(this.getDefaultPerPage()).all();
    }

    public List<Project> getStarredProjects(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("starred", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getStarredProjects(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("starred", true).withParam("per_page", this.getDefaultPerPage());
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public Stream<Project> getStarredProjectsStream() throws GitLabApiException {
        return this.getStarredProjects(this.getDefaultPerPage()).stream();
    }

    public List<Project> getProjects(ProjectFilter filter) throws GitLabApiException {
        return this.getProjects(filter, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(ProjectFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(ProjectFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects");
    }

    public Stream<Project> getProjectsStream(ProjectFilter filter) throws GitLabApiException {
        return this.getProjects(filter, this.getDefaultPerPage()).stream();
    }

    public List<Project> getUserProjects(Object userIdOrUsername, ProjectFilter filter) throws GitLabApiException {
        return this.getUserProjects(userIdOrUsername, filter, this.getDefaultPerPage()).all();
    }

    public List<Project> getUserProjects(Object userIdOrUsername, ProjectFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getUserProjects(Object userIdOrUsername, ProjectFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "projects");
    }

    public Stream<Project> getUserProjectsStream(Object userIdOrUsername, ProjectFilter filter) throws GitLabApiException {
        return this.getUserProjects(userIdOrUsername, filter, this.getDefaultPerPage()).stream();
    }

    public Project getProject(Object projectIdOrPath) throws GitLabApiException {
        return this.getProject(projectIdOrPath, null, null, null);
    }

    public Optional<Project> getOptionalProject(Object projectIdOrPath) {
        try {
            return Optional.ofNullable(this.getProject(projectIdOrPath, null, null, null));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Project getProject(Object projectIdOrPath, Boolean includeStatistics) throws GitLabApiException {
        return this.getProject(projectIdOrPath, includeStatistics, null, null);
    }

    public Optional<Project> getOptionalProject(Object projectIdOrPath, Boolean includeStatistics) {
        try {
            return Optional.ofNullable(this.getProject(projectIdOrPath, includeStatistics, null, null));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Project getProject(Object projectIdOrPath, Boolean includeStatistics, Boolean includeLicense, Boolean withCustomAttributes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("statistics", includeStatistics).withParam("license", includeLicense).withParam("with_custom_attributes", withCustomAttributes);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath));
        return (Project)response.readEntity(Project.class);
    }

    public Optional<Project> getOptionalProject(Object projectIdOrPath, Boolean includeStatistics, Boolean includeLicense, Boolean withCustomAttributes) {
        try {
            return Optional.ofNullable(this.getProject(projectIdOrPath, includeStatistics, includeLicense, withCustomAttributes));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Project getProject(String namespace, String project) throws GitLabApiException {
        if (namespace == null) {
            throw new RuntimeException("namespace cannot be null");
        }
        if (project == null) {
            throw new RuntimeException("project cannot be null");
        }
        String projectPath = null;
        try {
            projectPath = URLEncoder.encode(namespace + "/" + project, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectPath);
        return (Project)response.readEntity(Project.class);
    }

    public Optional<Project> getOptionalProject(String namespace, String project) {
        try {
            return Optional.ofNullable(this.getProject(namespace, project));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Project getProject(String namespace, String project, Boolean includeStatistics) throws GitLabApiException {
        if (namespace == null) {
            throw new RuntimeException("namespace cannot be null");
        }
        if (project == null) {
            throw new RuntimeException("project cannot be null");
        }
        String projectPath = null;
        try {
            projectPath = URLEncoder.encode(namespace + "/" + project, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("statistics", includeStatistics);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectPath);
        return (Project)response.readEntity(Project.class);
    }

    public Optional<Project> getOptionalProject(String namespace, String project, Boolean includeStatistics) {
        try {
            return Optional.ofNullable(this.getProject(namespace, project, includeStatistics));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Project createProject(Long namespaceId, String projectName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("namespace_id", namespaceId).withParam("name", projectName, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Long namespaceId, Project project) throws GitLabApiException {
        if (project == null) {
            throw new RuntimeException("Project instance cannot be null.");
        }
        Namespace namespace = new Namespace().withId(namespaceId);
        project.setNamespace(namespace);
        return this.createProject(project);
    }

    public Project createProject(String projectName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", projectName, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String name, String path) throws GitLabApiException {
        if ((name == null || name.trim().isEmpty()) && (path == null || path.trim().isEmpty())) {
            throw new RuntimeException("Either name or path must be specified.");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Project project) throws GitLabApiException {
        return this.createProject(project, null);
    }

    public Project createProject(Project project, String importUrl) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        String name = project.getName();
        String path = project.getPath();
        if (!(name != null && name.trim().length() != 0 || path != null && path.trim().length() != 0)) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("default_branch", project.getDefaultBranch()).withParam("description", project.getDescription()).withParam("issues_enabled", project.getIssuesEnabled()).withParam("merge_method", (Object)project.getMergeMethod()).withParam("merge_requests_enabled", project.getMergeRequestsEnabled()).withParam("jobs_enabled", project.getJobsEnabled()).withParam("wiki_enabled", project.getWikiEnabled()).withParam("container_registry_enabled", project.getContainerRegistryEnabled()).withParam("snippets_enabled", project.getSnippetsEnabled()).withParam("shared_runners_enabled", project.getSharedRunnersEnabled()).withParam("public_jobs", project.getPublicJobs()).withParam("visibility_level", project.getVisibilityLevel()).withParam("only_allow_merge_if_pipeline_succeeds", project.getOnlyAllowMergeIfPipelineSucceeds()).withParam("only_allow_merge_if_all_discussions_are_resolved", project.getOnlyAllowMergeIfAllDiscussionsAreResolved()).withParam("lfs_enabled", project.getLfsEnabled()).withParam("request_access_enabled", project.getRequestAccessEnabled()).withParam("repository_storage", project.getRepositoryStorage()).withParam("approvals_before_merge", project.getApprovalsBeforeMerge()).withParam("import_url", importUrl).withParam("printing_merge_request_link_enabled", project.getPrintingMergeRequestLinkEnabled()).withParam("resolve_outdated_diff_discussions", project.getResolveOutdatedDiffDiscussions()).withParam("initialize_with_readme", project.getInitializeWithReadme()).withParam("packages_enabled", project.getPackagesEnabled()).withParam("build_git_strategy", (Object)project.getBuildGitStrategy()).withParam("build_coverage_regex", project.getBuildCoverageRegex()).withParam("ci_config_path", project.getCiConfigPath()).withParam("suggestion_commit_message", project.getSuggestionCommitMessage()).withParam("remove_source_branch_after_merge", project.getRemoveSourceBranchAfterMerge()).withParam("squash_option", (Object)project.getSquashOption());
        Namespace namespace = project.getNamespace();
        if (namespace != null && namespace.getId() != null) {
            formData.withParam("namespace_id", namespace.getId());
        }
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            boolean isPublic = project.getPublic() != null ? project.getPublic() : project.getVisibility() == Visibility.PUBLIC;
            formData.withParam("public", isPublic);
            if (project.getTagList() != null && !project.getTagList().isEmpty()) {
                throw new IllegalArgumentException("GitLab API v3 does not support tag lists when creating projects");
            }
        } else {
            Visibility visibility = project.getVisibility() != null ? project.getVisibility() : (project.getPublic() == Boolean.TRUE ? Visibility.PUBLIC : null);
            formData.withParam("visibility", (Object)visibility);
            if (project.getTagList() != null && !project.getTagList().isEmpty()) {
                formData.withParam("tag_list", String.join((CharSequence)",", project.getTagList()));
            }
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String name, Long namespaceId, String description, Boolean issuesEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Visibility visibility, Integer visibilityLevel, String importUrl) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            Boolean isPublic = Visibility.PUBLIC == visibility;
            return this.createProject(name, namespaceId, description, issuesEnabled, mergeRequestsEnabled, wikiEnabled, snippetsEnabled, isPublic, visibilityLevel, importUrl);
        }
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("namespace_id", namespaceId).withParam("description", description).withParam("issues_enabled", issuesEnabled).withParam("merge_requests_enabled", mergeRequestsEnabled).withParam("wiki_enabled", wikiEnabled).withParam("snippets_enabled", snippetsEnabled).withParam("visibility_level", visibilityLevel).withParam("visibility", (Object)visibility).withParam("import_url", importUrl);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String name, Long namespaceId, String description, Boolean issuesEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Visibility visibility, Integer visibilityLevel, Boolean printingMergeRequestLinkEnabled, String importUrl) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            Boolean isPublic = Visibility.PUBLIC == visibility;
            return this.createProject(name, namespaceId, description, issuesEnabled, mergeRequestsEnabled, wikiEnabled, snippetsEnabled, isPublic, visibilityLevel, importUrl);
        }
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("namespace_id", namespaceId).withParam("description", description).withParam("issues_enabled", issuesEnabled).withParam("merge_requests_enabled", mergeRequestsEnabled).withParam("wiki_enabled", wikiEnabled).withParam("snippets_enabled", snippetsEnabled).withParam("visibility_level", visibilityLevel).withParam("visibility", (Object)visibility).withParam("printing_merge_request_link_enabled", printingMergeRequestLinkEnabled).withParam("import_url", importUrl);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    @Deprecated
    public Project createProject(String name, Long namespaceId, String description, Boolean issuesEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean isPublic, Integer visibilityLevel, String importUrl) throws GitLabApiException {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("namespace_id", namespaceId).withParam("description", description).withParam("issues_enabled", issuesEnabled).withParam("merge_requests_enabled", mergeRequestsEnabled).withParam("wiki_enabled", wikiEnabled).withParam("snippets_enabled", snippetsEnabled).withParam("visibility_level", visibilityLevel).withParam("import_url", importUrl);
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            formData.withParam("public", isPublic);
        } else if (isPublic.booleanValue()) {
            formData.withParam("visibility", (Object)Visibility.PUBLIC);
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createProjectFromTemplate(Integer namespaceId, String projectName, Integer groupWithProjectTemplatesId, String templateName, Visibility visibility) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("namespace_id", namespaceId).withParam("name", projectName, true).withParam("use_custom_template", true).withParam("group_with_project_templates_id", groupWithProjectTemplatesId, true).withParam("template_name", templateName, true).withParam("visibility", (Object)visibility);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects"});
        return (Project)response.readEntity(Project.class);
    }

    public Project updateProject(Project project) throws GitLabApiException {
        if (project == null) {
            throw new RuntimeException("Project instance cannot be null.");
        }
        Object projectIdentifier = this.getProjectIdOrPath(project);
        GitLabApiForm formData = new GitLabApiForm().withParam("name", project.getName()).withParam("path", project.getPath()).withParam("default_branch", project.getDefaultBranch()).withParam("description", project.getDescription()).withParam("issues_enabled", project.getIssuesEnabled()).withParam("merge_method", (Object)project.getMergeMethod()).withParam("merge_requests_enabled", project.getMergeRequestsEnabled()).withParam("jobs_enabled", project.getJobsEnabled()).withParam("wiki_enabled", project.getWikiEnabled()).withParam("snippets_enabled", project.getSnippetsEnabled()).withParam("container_registry_enabled", project.getContainerRegistryEnabled()).withParam("shared_runners_enabled", project.getSharedRunnersEnabled()).withParam("public_jobs", project.getPublicJobs()).withParam("only_allow_merge_if_pipeline_succeeds", project.getOnlyAllowMergeIfPipelineSucceeds()).withParam("only_allow_merge_if_all_discussions_are_resolved", project.getOnlyAllowMergeIfAllDiscussionsAreResolved()).withParam("lfs_enabled", project.getLfsEnabled()).withParam("request_access_enabled", project.getRequestAccessEnabled()).withParam("repository_storage", project.getRepositoryStorage()).withParam("approvals_before_merge", project.getApprovalsBeforeMerge()).withParam("printing_merge_request_link_enabled", project.getPrintingMergeRequestLinkEnabled()).withParam("resolve_outdated_diff_discussions", project.getResolveOutdatedDiffDiscussions()).withParam("packages_enabled", project.getPackagesEnabled()).withParam("build_git_strategy", (Object)project.getBuildGitStrategy()).withParam("build_coverage_regex", project.getBuildCoverageRegex()).withParam("ci_config_path", project.getCiConfigPath()).withParam("ci_forward_deployment_enabled", project.getCiForwardDeploymentEnabled()).withParam("merge_method", (Object)project.getMergeMethod()).withParam("suggestion_commit_message", project.getSuggestionCommitMessage()).withParam("remove_source_branch_after_merge", project.getRemoveSourceBranchAfterMerge()).withParam("squash_option", (Object)project.getSquashOption());
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            formData.withParam("visibility_level", project.getVisibilityLevel());
            boolean isPublic = project.getPublic() != null ? project.getPublic() : project.getVisibility() == Visibility.PUBLIC;
            formData.withParam("public", isPublic);
            if (project.getTagList() != null && !project.getTagList().isEmpty()) {
                throw new IllegalArgumentException("GitLab API v3 does not support tag lists when updating projects");
            }
        } else {
            Visibility visibility = project.getVisibility() != null ? project.getVisibility() : (project.getPublic() == Boolean.TRUE ? Visibility.PUBLIC : null);
            formData.withParam("visibility", (Object)visibility);
            if (project.getTagList() != null && !project.getTagList().isEmpty()) {
                formData.withParam("tag_list", String.join((CharSequence)",", project.getTagList()));
            }
        }
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", projectIdentifier);
        return (Project)response.readEntity(Project.class);
    }

    public void deleteProject(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.ACCEPTED;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath));
    }

    public Project forkProject(Object projectIdOrPath, String namespace) throws GitLabApiException {
        return this.forkProject(projectIdOrPath, namespace, null, null);
    }

    public Project forkProject(Object projectIdOrPath, Long namespaceId) throws GitLabApiException {
        return this.forkProject(projectIdOrPath, Long.toString(namespaceId));
    }

    public Project forkProject(Object projectIdOrPath, String namespace, String path, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("namespace", namespace, true).withParam("path", path).withParam("name", name);
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.CREATED;
        Response response = this.post(expectedStatus, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "fork"});
        return (Project)response.readEntity(Project.class);
    }

    public Project createForkedFromRelationship(Object projectIdOrPath, Long forkedFromId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.CREATED;
        Response response = this.post(expectedStatus, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "fork", forkedFromId});
        return (Project)response.readEntity(Project.class);
    }

    public void deleteForkedFromRelationship(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.ACCEPTED;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "fork");
    }

    public List<Member> getMembers(Object projectIdOrPath) throws GitLabApiException {
        return this.getMembers(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Member> getMembers(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getMembers(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "members");
    }

    public Stream<Member> getMembersStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getMembers(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Member> getAllMembers(Object projectIdOrPath) throws GitLabApiException {
        return this.getAllMembers(projectIdOrPath, null, null);
    }

    @Deprecated
    public List<Member> getAllMembers(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "members", "all");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getAllMembers(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getAllMembers(projectIdOrPath, null, null, itemsPerPage);
    }

    public Stream<Member> getAllMembersStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getAllMembersStream(projectIdOrPath, null, null);
    }

    public List<Member> getAllMembers(Object projectIdOrPath, String query, List<Long> userIds) throws GitLabApiException {
        return this.getAllMembers(projectIdOrPath, query, userIds, this.getDefaultPerPage()).all();
    }

    public Pager<Member> getAllMembers(Object projectIdOrPath, String query, List<Long> userIds, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("query", query).withParam("user_ids", userIds);
        return new Pager<Member>(this, Member.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "members", "all");
    }

    public Stream<Member> getAllMembersStream(Object projectIdOrPath, String query, List<Long> userIds) throws GitLabApiException {
        return this.getAllMembers(projectIdOrPath, query, userIds, this.getDefaultPerPage()).stream();
    }

    public Member getMember(Object projectIdOrPath, Long userId) throws GitLabApiException {
        return this.getMember(projectIdOrPath, userId, false);
    }

    public Optional<Member> getOptionalMember(Object projectIdOrPath, Long userId) {
        try {
            return Optional.ofNullable(this.getMember(projectIdOrPath, userId, false));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Member getMember(Object projectIdOrPath, Long userId, Boolean includeInherited) throws GitLabApiException {
        Response response = includeInherited != false ? this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "members", "all", userId) : this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "members", userId);
        return (Member)response.readEntity(Member.class);
    }

    public Optional<Member> getOptionalMember(Object projectIdOrPath, Long userId, Boolean includeInherited) {
        try {
            return Optional.ofNullable(this.getMember(projectIdOrPath, userId, includeInherited));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Member addMember(Object projectIdOrPath, Long userId, Integer accessLevel) throws GitLabApiException {
        return this.addMember(projectIdOrPath, userId, accessLevel, null);
    }

    public Member addMember(Object projectIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.addMember(projectIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member addMember(Object projectIdOrPath, Long userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.addMember(projectIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member addMember(Object projectIdOrPath, Long userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("user_id", userId, true).withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "members"});
        return (Member)response.readEntity(Member.class);
    }

    public Member updateMember(Object projectIdOrPath, Long userId, Integer accessLevel) throws GitLabApiException {
        return this.updateMember(projectIdOrPath, userId, accessLevel, null);
    }

    public Member updateMember(Object projectIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.updateMember(projectIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member updateMember(Object projectIdOrPath, Long userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.updateMember(projectIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member updateMember(Object projectIdOrPath, Long userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "members", userId});
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Object projectIdOrPath, Long userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "members", userId);
    }

    public List<ProjectUser> getProjectUsers(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectUsers(projectIdOrPath, null, this.getDefaultPerPage()).all();
    }

    public Pager<ProjectUser> getProjectUsers(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getProjectUsers(projectIdOrPath, null, itemsPerPage);
    }

    public Stream<ProjectUser> getProjectUsersStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectUsers(projectIdOrPath, null, this.getDefaultPerPage()).stream();
    }

    public List<ProjectUser> getProjectUsers(Object projectIdOrPath, String search) throws GitLabApiException {
        return this.getProjectUsers(projectIdOrPath, search, this.getDefaultPerPage()).all();
    }

    public Pager<ProjectUser> getProjectUsers(Object projectIdOrPath, String search, int itemsPerPage) throws GitLabApiException {
        MultivaluedMap params = search != null ? new GitLabApiForm().withParam("search", search).asMap() : null;
        return new Pager<ProjectUser>(this, ProjectUser.class, itemsPerPage, (MultivaluedMap<String, String>)params, "projects", this.getProjectIdOrPath(projectIdOrPath), "users");
    }

    public Stream<ProjectUser> getProjectUsersStream(Object projectIdOrPath, String search) throws GitLabApiException {
        return this.getProjectUsers(projectIdOrPath, search, this.getDefaultPerPage()).stream();
    }

    public List<ProjectGroup> getProjectGroups(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectGroups(projectIdOrPath, new ProjectGroupsFilter(), this.getDefaultPerPage()).all();
    }

    public Pager<ProjectGroup> getProjectGroups(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getProjectGroups(projectIdOrPath, new ProjectGroupsFilter(), itemsPerPage);
    }

    public Stream<ProjectGroup> getProjectGroupsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectGroups(projectIdOrPath, new ProjectGroupsFilter(), this.getDefaultPerPage()).stream();
    }

    public List<ProjectGroup> getProjectGroups(Object projectIdOrPath, ProjectGroupsFilter filter) throws GitLabApiException {
        return this.getProjectGroups(projectIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public Pager<ProjectGroup> getProjectGroups(Object projectIdOrPath, ProjectGroupsFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<ProjectGroup>(this, ProjectGroup.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "groups");
    }

    public Stream<ProjectGroup> getProjectGroupsStream(Object projectIdOrPath, ProjectGroupsFilter filter) throws GitLabApiException {
        return this.getProjectGroups(projectIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public List<Event> getProjectEvents(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Event> getProjectEvents(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getProjectEvents(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Event>(this, Event.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
    }

    public Stream<Event> getProjectEventsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<ProjectHook> getHooks(Object projectIdOrPath) throws GitLabApiException {
        return this.getHooks(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<ProjectHook> getHooks(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "hooks");
        return (List)response.readEntity((GenericType)new GenericType<List<ProjectHook>>(){});
    }

    public Pager<ProjectHook> getHooks(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<ProjectHook>(this, ProjectHook.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "hooks");
    }

    public Stream<ProjectHook> getHooksStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getHooks(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public ProjectHook getHook(Object projectIdOrPath, Long hookId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "hooks", hookId);
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public Optional<ProjectHook> getOptionalHook(Object projectIdOrPath, Long hookId) {
        try {
            return Optional.ofNullable(this.getHook(projectIdOrPath, hookId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public ProjectHook addHook(Object projectIdOrPath, String url, ProjectHook enabledHooks, boolean enableSslVerification, String secretToken) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("push_events", enabledHooks.getPushEvents(), false).withParam("push_events_branch_filter", enabledHooks.getPushEventsBranchFilter(), false).withParam("issues_events", enabledHooks.getIssuesEvents(), false).withParam("confidential_issues_events", enabledHooks.getConfidentialIssuesEvents(), false).withParam("merge_requests_events", enabledHooks.getMergeRequestsEvents(), false).withParam("tag_push_events", enabledHooks.getTagPushEvents(), false).withParam("note_events", enabledHooks.getNoteEvents(), false).withParam("confidential_note_events", enabledHooks.getConfidentialNoteEvents(), false).withParam("job_events", enabledHooks.getJobEvents(), false).withParam("pipeline_events", enabledHooks.getPipelineEvents(), false).withParam("wiki_page_events", enabledHooks.getWikiPageEvents(), false).withParam("enable_ssl_verification", enableSslVerification, false).withParam("repository_update_events", enabledHooks.getRepositoryUpdateEvents(), false).withParam("deployment_events", enabledHooks.getDeploymentEvents(), false).withParam("releases_events", enabledHooks.getReleasesEvents(), false).withParam("deployment_events", enabledHooks.getDeploymentEvents(), false).withParam("token", secretToken, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "hooks"});
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public ProjectHook addHook(Object projectIdOrPath, String url, boolean doPushEvents, boolean doIssuesEvents, boolean doMergeRequestsEvents) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url).withParam("push_events", doPushEvents).withParam("issues_events", doIssuesEvents).withParam("merge_requests_events", doMergeRequestsEvents);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "hooks"});
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public void deleteHook(Object projectIdOrPath, Long hookId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "hooks", hookId);
    }

    public void deleteHook(ProjectHook hook) throws GitLabApiException {
        this.deleteHook(hook.getProjectId(), hook.getId());
    }

    public ProjectHook modifyHook(ProjectHook hook) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", hook.getUrl(), true).withParam("push_events", hook.getPushEvents(), false).withParam("push_events_branch_filter", hook.getPushEventsBranchFilter(), false).withParam("issues_events", hook.getIssuesEvents(), false).withParam("confidential_issues_events", hook.getConfidentialIssuesEvents(), false).withParam("merge_requests_events", hook.getMergeRequestsEvents(), false).withParam("tag_push_events", hook.getTagPushEvents(), false).withParam("note_events", hook.getNoteEvents(), false).withParam("confidential_note_events", hook.getConfidentialNoteEvents(), false).withParam("job_events", hook.getJobEvents(), false).withParam("pipeline_events", hook.getPipelineEvents(), false).withParam("wiki_page_events", hook.getWikiPageEvents(), false).withParam("enable_ssl_verification", hook.getEnableSslVerification(), false).withParam("repository_update_events", hook.getRepositoryUpdateEvents(), false).withParam("releases_events", hook.getReleasesEvents(), false).withParam("deployment_events", hook.getDeploymentEvents(), false).withParam("token", hook.getToken(), false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", hook.getProjectId(), "hooks", hook.getId()});
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    @Deprecated
    public List<Issue> getIssues(Object projectIdOrPath) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    @Deprecated
    public List<Issue> getIssues(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    @Deprecated
    public Pager<Issue> getIssues(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
    }

    @Deprecated
    public Stream<Issue> getIssuesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    @Deprecated
    public Issue getIssue(Object projectIdOrPath, Long issueId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueId);
        return (Issue)response.readEntity(Issue.class);
    }

    @Deprecated
    public void deleteIssue(Object projectIdOrPath, Long issueId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueId);
    }

    public List<Snippet> getSnippets(Object projectIdOrPath) throws GitLabApiException {
        return this.getSnippets(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Snippet> getSnippets(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets");
        return (List)response.readEntity((GenericType)new GenericType<List<Snippet>>(){});
    }

    public Pager<Snippet> getSnippets(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Snippet>(this, Snippet.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets");
    }

    public Stream<Snippet> getSnippetsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getSnippets(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Snippet getSnippet(Object projectIdOrPath, Long snippetId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId);
        return (Snippet)response.readEntity(Snippet.class);
    }

    public Optional<Snippet> getOptionalSnippet(Object projectIdOrPath, Long snippetId) {
        try {
            return Optional.ofNullable(this.getSnippet(projectIdOrPath, snippetId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Snippet createSnippet(Object projectIdOrPath, String title, String filename, String description, String content, Visibility visibility) throws GitLabApiException {
        try {
            GitLabApiForm form = new GitLabApiForm().withParam("title", title, true).withParam("file_name", filename, true).withParam("description", description).withParam("content", content, true).withParam("visibility", (Object)visibility, true);
            Response response = this.post(Response.Status.CREATED, (Form)form, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "snippets"});
            return (Snippet)response.readEntity(Snippet.class);
        }
        catch (GitLabApiException glae) {
            if (glae.getHttpStatus() != Response.Status.BAD_REQUEST.getStatusCode()) {
                throw glae;
            }
            GitLabApiForm form = new GitLabApiForm().withParam("title", title, true).withParam("file_name", filename, true).withParam("description", description).withParam("code", content, true).withParam("visibility", (Object)visibility, true);
            Response response = this.post(Response.Status.CREATED, (Form)form, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "snippets"});
            return (Snippet)response.readEntity(Snippet.class);
        }
    }

    public Snippet updateSnippet(Object projectIdOrPath, Long snippetId, String title, String filename, String description, String code, Visibility visibility) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("file_name", filename).withParam("description", description).withParam("code", code).withParam("visibility", (Object)visibility);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId});
        return (Snippet)response.readEntity(Snippet.class);
    }

    public void deleteSnippet(Object projectIdOrPath, Long snippetId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId);
    }

    public String getRawSnippetContent(Object projectIdOrPath, Long snippetId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "raw");
        return (String)response.readEntity(String.class);
    }

    public Optional<String> getOptionalRawSnippetContent(Object projectIdOrPath, Long snippetId) {
        try {
            return Optional.ofNullable(this.getRawSnippetContent(projectIdOrPath, snippetId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void shareProject(Object projectIdOrPath, Long groupId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("group_id", groupId, true).withParam("group_access", accessLevel, true).withParam("expires_at", expiresAt);
        this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "share"});
    }

    public void unshareProject(Object projectIdOrPath, Long groupId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "share", groupId);
    }

    public Project archiveProject(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)new GitLabApiForm(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "archive"});
        return (Project)response.readEntity(Project.class);
    }

    public Project unarchiveProject(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)new GitLabApiForm(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "unarchive"});
        return (Project)response.readEntity(Project.class);
    }

    public FileUpload uploadFile(Object projectIdOrPath, File fileToUpload) throws GitLabApiException {
        return this.uploadFile(projectIdOrPath, fileToUpload, null);
    }

    public FileUpload uploadFile(Object projectIdOrPath, File fileToUpload, String mediaType) throws GitLabApiException {
        Response response = this.upload(Response.Status.CREATED, "file", fileToUpload, mediaType, "projects", this.getProjectIdOrPath(projectIdOrPath), "uploads");
        return (FileUpload)response.readEntity(FileUpload.class);
    }

    public FileUpload uploadFile(Object projectIdOrPath, InputStream inputStream, String filename, String mediaType) throws GitLabApiException {
        Response response = this.upload(Response.Status.CREATED, "file", inputStream, filename, mediaType, "projects", this.getProjectIdOrPath(projectIdOrPath), "uploads");
        return (FileUpload)response.readEntity(FileUpload.class);
    }

    public PushRules getPushRules(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "push_rule");
        return (PushRules)response.readEntity(PushRules.class);
    }

    public PushRules createPushRules(Object projectIdOrPath, PushRules pushRule) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("deny_delete_tag", pushRule.getDenyDeleteTag()).withParam("member_check", pushRule.getMemberCheck()).withParam("prevent_secrets", pushRule.getPreventSecrets()).withParam("commit_message_regex", pushRule.getCommitMessageRegex()).withParam("commit_message_negative_regex", pushRule.getCommitMessageNegativeRegex()).withParam("branch_name_regex", pushRule.getBranchNameRegex()).withParam("author_email_regex", pushRule.getAuthorEmailRegex()).withParam("file_name_regex", pushRule.getFileNameRegex()).withParam("max_file_size", pushRule.getMaxFileSize()).withParam("commit_committer_check", pushRule.getCommitCommitterCheck()).withParam("reject_unsigned_commits", pushRule.getRejectUnsignedCommits());
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "push_rule"});
        return (PushRules)response.readEntity(PushRules.class);
    }

    public PushRules updatePushRules(Object projectIdOrPath, PushRules pushRule) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("deny_delete_tag", pushRule.getDenyDeleteTag()).withParam("member_check", pushRule.getMemberCheck()).withParam("prevent_secrets", pushRule.getPreventSecrets()).withParam("commit_message_regex", pushRule.getCommitMessageRegex()).withParam("commit_message_negative_regex", pushRule.getCommitMessageNegativeRegex()).withParam("branch_name_regex", pushRule.getBranchNameRegex()).withParam("author_email_regex", pushRule.getAuthorEmailRegex()).withParam("file_name_regex", pushRule.getFileNameRegex()).withParam("max_file_size", pushRule.getMaxFileSize()).withParam("commit_committer_check", pushRule.getCommitCommitterCheck()).withParam("reject_unsigned_commits", pushRule.getRejectUnsignedCommits());
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "push_rule");
        return (PushRules)response.readEntity(PushRules.class);
    }

    public void deletePushRules(Object projectIdOrPath) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "push_rule");
    }

    public List<Project> getForks(Object projectIdOrPath) throws GitLabApiException {
        return this.getForks(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Project> getForks(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "forks");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getForks(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "forks");
    }

    public Stream<Project> getForksStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getForks(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Project starProject(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.CREATED;
        Response response = this.post(expectedStatus, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "star"});
        return (Project)response.readEntity(Project.class);
    }

    public Project unstarProject(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.CREATED;
        Response response = this.post(expectedStatus, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "unstar"});
        return (Project)response.readEntity(Project.class);
    }

    public Map<String, Float> getProjectLanguages(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "languages");
        return (Map)response.readEntity((GenericType)new GenericType<Map<String, Float>>(){});
    }

    public Project transferProject(Object projectIdOrPath, String namespace) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("namespace", namespace, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "transfer"});
        return (Project)response.readEntity(Project.class);
    }

    public Project setProjectAvatar(Object projectIdOrPath, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "projects", this.getProjectIdOrPath(projectIdOrPath));
        return (Project)response.readEntity(Project.class);
    }

    public List<AuditEvent> getAuditEvents(Object projectIdOrPath, Date created_after, Date created_before) throws GitLabApiException {
        return this.getAuditEvents(projectIdOrPath, created_after, created_before, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Object projectIdOrPath, Date created_after, Date created_before, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_before, false)).withParam("created_after", ISO8601.toString(created_after, false));
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Object projectIdOrPath, Date created_after, Date created_before) throws GitLabApiException {
        return this.getAuditEvents(projectIdOrPath, created_after, created_before, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Object projectIdOrPath, Long auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "audit_events", auditEventId);
        return (AuditEvent)response.readEntity(AuditEvent.class);
    }

    public List<Variable> getVariables(Object projectIdOrPath) throws GitLabApiException {
        return this.getVariables(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Variable> getVariables(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "variables");
        return (List)response.readEntity((GenericType)new GenericType<List<Variable>>(){});
    }

    public Pager<Variable> getVariables(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Variable>(this, Variable.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "variables");
    }

    public Stream<Variable> getVariablesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getVariables(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Variable getVariable(Object projectIdOrPath, String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "variables", key);
        return (Variable)response.readEntity(Variable.class);
    }

    public Optional<Variable> getOptionalVariable(Object projectIdOrPath, String key) {
        try {
            return Optional.ofNullable(this.getVariable(projectIdOrPath, key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Variable createVariable(Object projectIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        return this.createVariable(projectIdOrPath, key, value, isProtected, null);
    }

    public Variable createVariable(Object projectIdOrPath, String key, String value, Boolean isProtected, String environmentScope) throws GitLabApiException {
        return this.createVariable(projectIdOrPath, key, value, null, isProtected, null, environmentScope);
    }

    public Variable createVariable(Object projectIdOrPath, String key, String value, Variable.Type variableType, Boolean isProtected, Boolean isMasked) throws GitLabApiException {
        return this.createVariable(projectIdOrPath, key, value, variableType, isProtected, isMasked, null);
    }

    public Variable createVariable(Object projectIdOrPath, String key, String value, Variable.Type variableType, Boolean isProtected, Boolean isMasked, String environmentScope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true).withParam("value", value, true).withParam("variable_type", (Object)variableType).withParam("protected", isProtected).withParam("masked", isMasked).withParam("environment_scope", environmentScope);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "variables"});
        return (Variable)response.readEntity(Variable.class);
    }

    public Variable updateVariable(Object projectIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        return this.updateVariable(projectIdOrPath, key, value, null, isProtected, null, null);
    }

    public Variable updateVariable(Object projectIdOrPath, String key, String value, Boolean isProtected, String environmentScope) throws GitLabApiException {
        return this.updateVariable(projectIdOrPath, key, value, null, isProtected, null, environmentScope);
    }

    public Variable updateVariable(Object projectIdOrPath, String key, String value, Variable.Type variableType, Boolean isProtected, Boolean masked) throws GitLabApiException {
        return this.updateVariable(projectIdOrPath, key, value, variableType, isProtected, masked, null);
    }

    public Variable updateVariable(Object projectIdOrPath, String key, String value, Variable.Type variableType, Boolean isProtected, Boolean masked, String environmentScope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value, true).withParam("variable_type", (Object)variableType).withParam("protected", isProtected).withParam("masked", masked).withParam("environment_scope", environmentScope);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "variables", key);
        return (Variable)response.readEntity(Variable.class);
    }

    public void deleteVariable(Object projectIdOrPath, String key) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "variables", key);
    }

    public List<AccessRequest> getAccessRequests(Object projectIdOrPath) throws GitLabApiException {
        return this.getAccessRequests(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<AccessRequest> getAccessRequests(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<AccessRequest>(this, AccessRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "access_requests");
    }

    public Stream<AccessRequest> getAccessRequestsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getAccessRequests(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public AccessRequest requestAccess(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "access_requests"});
        return (AccessRequest)response.readEntity(AccessRequest.class);
    }

    public AccessRequest approveAccessRequest(Object projectIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel);
        Response response = this.putWithFormData(Response.Status.CREATED, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "access_requests", userId, "approve");
        return (AccessRequest)response.readEntity(AccessRequest.class);
    }

    public void denyAccessRequest(Object projectIdOrPath, Long userId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "access_requests", userId);
    }

    public void triggerHousekeeping(Object projectIdOrPath) throws GitLabApiException {
        this.post(Response.Status.OK, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "housekeeping"});
    }

    public List<Badge> getBadges(Object projectIdOrPath) throws GitLabApiException {
        return this.getBadges(projectIdOrPath, null);
    }

    public List<Badge> getBadges(Object projectIdOrPath, String bagdeName) throws GitLabApiException {
        GitLabApiForm queryParam = new GitLabApiForm().withParam("name", bagdeName);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParam.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "badges");
        return (List)response.readEntity((GenericType)new GenericType<List<Badge>>(){});
    }

    public Badge getBadge(Object projectIdOrPath, Long badgeId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "badges", badgeId);
        return (Badge)response.readEntity(Badge.class);
    }

    public Optional<Badge> getOptionalBadge(Object projectIdOrPath, Long badgeId) {
        try {
            return Optional.ofNullable(this.getBadge(projectIdOrPath, badgeId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Badge addBadge(Object projectIdOrPath, String linkUrl, String imageUrl) throws GitLabApiException {
        return this.addBadge(projectIdOrPath, null, linkUrl, imageUrl);
    }

    public Badge addBadge(Object projectIdOrPath, String name, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, false).withParam("link_url", linkUrl, true).withParam("image_url", imageUrl, true);
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "badges"});
        return (Badge)response.readEntity(Badge.class);
    }

    public Badge editBadge(Object projectIdOrPath, Long badgeId, String linkUrl, String imageUrl) throws GitLabApiException {
        return this.editBadge(projectIdOrPath, badgeId, null, linkUrl, imageUrl);
    }

    public Badge editBadge(Object projectIdOrPath, Long badgeId, String name, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, false).withParam("link_url", linkUrl, false).withParam("image_url", imageUrl, false);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "badges", badgeId);
        return (Badge)response.readEntity(Badge.class);
    }

    public void removeBadge(Object projectIdOrPath, Long badgeId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "badges", badgeId);
    }

    public Badge previewBadge(Object projectIdOrPath, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("link_url", linkUrl, true).withParam("image_url", imageUrl, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "badges", "render");
        return (Badge)response.readEntity(Badge.class);
    }

    public ProjectApprovalsConfig getApprovalsConfiguration(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "approvals");
        return (ProjectApprovalsConfig)response.readEntity(ProjectApprovalsConfig.class);
    }

    public ProjectApprovalsConfig setApprovalsConfiguration(Object projectIdOrPath, ProjectApprovalsConfig config) throws GitLabApiException {
        GitLabApiForm formData = config.getForm();
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "approvals"});
        return (ProjectApprovalsConfig)response.readEntity(ProjectApprovalsConfig.class);
    }

    public List<ApprovalRule> getApprovalRules(Object projectIdOrPath) throws GitLabApiException {
        return this.getApprovalRules(projectIdOrPath, -1).all();
    }

    public Pager<ApprovalRule> getApprovalRules(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<ApprovalRule>(this, ApprovalRule.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "approval_rules");
    }

    public Stream<ApprovalRule> getApprovalRulesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getApprovalRules(projectIdOrPath, -1).stream();
    }

    public ApprovalRule createApprovalRule(Object projectIdOrPath, ApprovalRuleParams params) throws GitLabApiException {
        GitLabApiForm formData = params.getForm();
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "approval_rules"});
        return (ApprovalRule)response.readEntity(ApprovalRule.class);
    }

    public ApprovalRule updateApprovalRule(Object projectIdOrPath, Long approvalRuleId, ApprovalRuleParams params) throws GitLabApiException {
        if (approvalRuleId == null) {
            throw new RuntimeException("approvalRuleId cannot be null");
        }
        GitLabApiForm formData = params.getForm();
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "approval_rules", approvalRuleId);
        return (ApprovalRule)response.readEntity(ApprovalRule.class);
    }

    public void deleteApprovalRule(Object projectIdOrPath, Long approvalRuleId) throws GitLabApiException {
        if (approvalRuleId == null) {
            throw new RuntimeException("approvalRuleId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "approval_rules", approvalRuleId);
    }

    public List<CustomAttribute> getCustomAttributes(Object projectIdOrPath) throws GitLabApiException {
        return this.getCustomAttributes(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<CustomAttribute> getCustomAttributes(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<CustomAttribute>(this, CustomAttribute.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "custom_attributes");
    }

    public Stream<CustomAttribute> getCustomAttributesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getCustomAttributes(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public CustomAttribute getCustomAttribute(Object projectIdOrPath, String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "custom_attributes", key);
        return (CustomAttribute)response.readEntity(CustomAttribute.class);
    }

    public Optional<CustomAttribute> geOptionalCustomAttribute(Object projectIdOrPath, String key) {
        try {
            return Optional.ofNullable(this.getCustomAttribute(projectIdOrPath, key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public CustomAttribute setCustomAttribute(Object projectIdOrPath, String key, String value) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "custom_attributes", key);
        return (CustomAttribute)response.readEntity(CustomAttribute.class);
    }

    public void deleteCustomAttribute(Object projectIdOrPath, String key) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "custom_attributes", key);
    }

    public List<RemoteMirror> getRemoteMirrors(Object projectIdOrPath) throws GitLabApiException {
        return this.getRemoteMirrors(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<RemoteMirror> getRemoteMirrors(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<RemoteMirror>(this, RemoteMirror.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "remote_mirrors");
    }

    public Stream<RemoteMirror> getRemoteMirrorsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getRemoteMirrors(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public RemoteMirror createRemoteMirror(Object projectIdOrPath, String url, Boolean enabled, Boolean onlyProtectedBranches, Boolean keepDivergentRefs) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("enabled", enabled).withParam("only_protected_branches", onlyProtectedBranches).withParam("keep_divergent_refs", keepDivergentRefs);
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "remote_mirrors"});
        return (RemoteMirror)response.readEntity(RemoteMirror.class);
    }

    public RemoteMirror updateRemoteMirror(Object projectIdOrPath, Long mirrorId, Boolean enabled, Boolean onlyProtectedBranches, Boolean keepDivergentRefs) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("enabled", enabled).withParam("only_protected_branches", onlyProtectedBranches).withParam("keep_divergent_refs", keepDivergentRefs);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "remote_mirrors", mirrorId);
        return (RemoteMirror)response.readEntity(RemoteMirror.class);
    }
}

