/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.ChildEpic;
import org.gitlab4j.api.models.CreatedChildEpic;
import org.gitlab4j.api.models.Epic;
import org.gitlab4j.api.models.EpicFilter;
import org.gitlab4j.api.models.EpicIssue;
import org.gitlab4j.api.models.EpicIssueLink;
import org.gitlab4j.api.models.LinkType;
import org.gitlab4j.api.models.RelatedEpic;
import org.gitlab4j.api.models.RelatedEpicLink;

public class EpicsApi
extends AbstractApi {
    public EpicsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Epic> getEpics(Object groupIdOrPath) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Epic> getEpics(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
        return (List)response.readEntity((GenericType)new GenericType<List<Epic>>(){});
    }

    public Pager<Epic> getEpics(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Epic>(this, Epic.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
    }

    public Stream<Epic> getEpicsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Epic> getEpics(Object groupIdOrPath, Long authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, authorId, labels, orderBy, sortOrder, search, this.getDefaultPerPage()).all();
    }

    public List<Epic> getEpics(Object groupIdOrPath, Long authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search, int page, int perPage) throws GitLabApiException {
        EpicFilter filter = this.createEpicFilter(authorId, labels, orderBy, sortOrder, search);
        return this.getEpics(groupIdOrPath, filter);
    }

    public List<Epic> getEpics(Object groupIdOrPath, EpicFilter filter) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, this.getDefaultPerPage(), filter).all();
    }

    public Pager<Epic> getEpics(Object groupIdOrPath, Long authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search, int itemsPerPage) throws GitLabApiException {
        EpicFilter filter = this.createEpicFilter(authorId, labels, orderBy, sortOrder, search);
        return this.getEpics(groupIdOrPath, itemsPerPage, filter);
    }

    public Pager<Epic> getEpics(Object groupIdOrPath, int itemsPerPage, EpicFilter filter) throws GitLabApiException {
        return new Pager<Epic>(this, Epic.class, itemsPerPage, (MultivaluedMap<String, String>)filter.getQueryParams().asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
    }

    private EpicFilter createEpicFilter(Long authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search) {
        return new EpicFilter().withAuthorId(authorId).withLabels(labels).withOrderBy(orderBy).withSortOrder(sortOrder).withSearch(search);
    }

    public Stream<Epic> getEpicsStream(Object groupIdOrPath, Long authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, authorId, labels, orderBy, sortOrder, search, this.getDefaultPerPage()).stream();
    }

    public Epic getEpic(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
        return (Epic)response.readEntity(Epic.class);
    }

    public Optional<Epic> getOptionalEpic(Object groupIdOrPath, Long epicIid) {
        try {
            return Optional.ofNullable(this.getEpic(groupIdOrPath, epicIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Epic createEpic(Object groupIdOrPath, String title, String labels, String description, Date startDate, Date endDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("labels", labels).withParam("description", description).withParam("start_date", startDate).withParam("end_date", endDate);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics"});
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic createEpic(Object groupIdOrPath, Epic epic) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", epic.getTitle(), true).withParam("labels", epic.getLabels()).withParam("description", epic.getDescription()).withParam("start_date", epic.getStartDate()).withParam("end_date", epic.getEndDate());
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics"});
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic updateEpic(Object groupIdOrPath, Long epicIid, String title, String labels, String description, Date startDate, Date endDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("labels", labels).withParam("description", description).withParam("start_date", startDate).withParam("end_date", endDate);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid});
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic updateEpic(Object groupIdOrPath, Long epicIid, Epic epic) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", epic.getTitle(), true).withParam("labels", epic.getLabels()).withParam("description", epic.getDescription()).withParam("start_date", epic.getStartDate()).withParam("end_date", epic.getEndDate());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid});
        return (Epic)response.readEntity(Epic.class);
    }

    public void deleteEpic(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
    }

    public List<EpicIssue> getEpicIssues(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getEpicIssues(groupIdOrPath, epicIid, this.getDefaultPerPage()).all();
    }

    public List<EpicIssue> getEpicIssues(Object groupIdOrPath, Long epicIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<EpicIssue>>(){});
    }

    public Pager<EpicIssue> getEpicIssues(Object groupIdOrPath, Long epicIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<EpicIssue>(this, EpicIssue.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues");
    }

    public Stream<EpicIssue> getEpicIssuesStream(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getEpicIssues(groupIdOrPath, epicIid, this.getDefaultPerPage()).stream();
    }

    public EpicIssue assignIssue(Object groupIdOrPath, Long epicIid, Long issueId) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", issueId});
        return (EpicIssue)response.readEntity(EpicIssue.class);
    }

    public EpicIssueLink removeIssue(Object groupIdOrPath, Long epicIid, Long epicIssueId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", epicIssueId);
        return (EpicIssueLink)response.readEntity(EpicIssueLink.class);
    }

    public List<EpicIssue> updateIssue(Object groupIdOrPath, Long epicIid, Long epicIssueId, Long moveBeforeId, Long moveAfterId) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("move_before_id", moveBeforeId).withParam("move_after_id", moveAfterId);
        Response response = this.put(Response.Status.OK, (Object)form, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", epicIssueId);
        return (List)response.readEntity((GenericType)new GenericType<List<EpicIssue>>(){});
    }

    public List<ChildEpic> getChildEpics(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getChildEpics(groupIdOrPath, epicIid, this.getDefaultPerPage()).all();
    }

    public Pager<ChildEpic> getChildEpics(Object groupIdOrPath, Long epicIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<ChildEpic>(this, ChildEpic.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "epics");
    }

    public Stream<ChildEpic> getChildEpicsStream(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getChildEpics(groupIdOrPath, epicIid, this.getDefaultPerPage()).stream();
    }

    public ChildEpic assignChildEpic(Object groupIdOrPath, Long epicIid, Long childEpicId) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "epics", childEpicId});
        return (ChildEpic)response.readEntity(ChildEpic.class);
    }

    public CreatedChildEpic createAndAssignChildEpic(Object groupIdOrPath, Long epicIid, String title, Boolean confidential) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("confidential", confidential);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "epics"});
        return (CreatedChildEpic)response.readEntity(CreatedChildEpic.class);
    }

    public List<ChildEpic> reOrderChildEpic(Object groupIdOrPath, Long epicIid, Long childEpicId, Long moveBeforeId, Long moveAfterId) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("move_before_id", moveBeforeId).withParam("move_after_id", moveAfterId);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "epics", childEpicId});
        return (List)response.readEntity((GenericType)new GenericType<List<ChildEpic>>(){});
    }

    public ChildEpic unassignChildEpic(Object groupIdOrPath, Long epicIid, Long childEpicId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "epics", childEpicId);
        return (ChildEpic)response.readEntity(ChildEpic.class);
    }

    public List<RelatedEpic> getRelatedEpics(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getRelatedEpics(groupIdOrPath, epicIid, this.getDefaultPerPage()).all();
    }

    public Pager<RelatedEpic> getRelatedEpics(Object groupIdOrPath, Long epicIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<RelatedEpic>(this, RelatedEpic.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "related_epics");
    }

    public Stream<RelatedEpic> getRelatedEpicsStream(Object groupIdOrPath, Long epicIid) throws GitLabApiException {
        return this.getRelatedEpics(groupIdOrPath, epicIid, this.getDefaultPerPage()).stream();
    }

    public RelatedEpicLink createRelatedEpicLink(Object groupIdOrPath, Long epicIid, Object targetGroupIdOrPath, Long targetEpicIid, LinkType linkType) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("target_group_id", this.getGroupIdOrPath(targetGroupIdOrPath), true).withParam("target_epic_iid", targetEpicIid, true).withParam("link_type", (Object)linkType);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "related_epics"});
        return (RelatedEpicLink)response.readEntity(RelatedEpicLink.class);
    }

    public RelatedEpicLink deleteRelatedEpicLink(Object groupIdOrPath, Long epicIid, Long relatedEpicLinkId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "related_epics", relatedEpicLinkId);
        return (RelatedEpicLink)response.readEntity(RelatedEpicLink.class);
    }
}

