/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PipelineStatus {
    CREATED,
    WAITING_FOR_RESOURCE,
    PREPARING,
    PENDING,
    RUNNING,
    SUCCESS,
    FAILED,
    CANCELED,
    SKIPPED,
    MANUAL,
    SCHEDULED;

    private static Map<String, PipelineStatus> valuesMap;

    static {
        valuesMap = new HashMap<String, PipelineStatus>(11);
        PipelineStatus[] pipelineStatusArray = PipelineStatus.values();
        int n = pipelineStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            PipelineStatus status = pipelineStatusArray[n2];
            valuesMap.put(status.toValue(), status);
            ++n2;
        }
    }

    @JsonCreator
    public static PipelineStatus forValue(String value) {
        return valuesMap.get(value);
    }

    @JsonValue
    public String toValue() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

