/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Discussion;

public class DiscussionsApi
extends AbstractApi {
    public DiscussionsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Discussion> getIssueDiscussions(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getIssueDiscussionsPager(projectIdOrPath, issueIid, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getIssueDiscussions(Object projectIdOrPath, Integer issueIid, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getIssueDiscussions(projectIdOrPath, issueIid);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "discussions");
        return (List)response.readEntity((GenericType)new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getIssueDiscussionsPager(Object projectIdOrPath, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "discussions");
    }

    public Stream<Discussion> getIssueDiscussionsStream(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getIssueDiscussionsPager(projectIdOrPath, issueIid, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getSnippetDiscussions(Object projectIdOrPath, Integer snippetId) throws GitLabApiException {
        Pager<Discussion> pager = this.getSnippetDiscussionsPager(projectIdOrPath, snippetId, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getSnippetDiscussions(Object projectIdOrPath, Integer snippetId, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getSnippetDiscussions(projectIdOrPath, snippetId);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "discussions");
        return (List)response.readEntity((GenericType)new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getSnippetDiscussionsPager(Object projectIdOrPath, Integer snippetId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "discussions");
    }

    public Stream<Discussion> getSnippetDiscussionsStream(Object projectIdOrPath, Integer snippetId) throws GitLabApiException {
        Pager<Discussion> pager = this.getSnippetDiscussionsPager(projectIdOrPath, snippetId, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getEpicDiscussions(Object projectIdOrPath, Integer epicId) throws GitLabApiException {
        Pager<Discussion> pager = this.getEpicDiscussionsPager(projectIdOrPath, epicId, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getEpicDiscussions(Object projectIdOrPath, Integer epicId, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getEpicDiscussions(projectIdOrPath, epicId);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "discussions");
        return (List)response.readEntity((GenericType)new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getEpicDiscussionsPager(Object projectIdOrPath, Integer epicId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "discussions");
    }

    public Stream<Discussion> getEpicDiscussionsStream(Object projectIdOrPath, Integer epicId) throws GitLabApiException {
        Pager<Discussion> pager = this.getEpicDiscussionsPager(projectIdOrPath, epicId, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getMergeRequestDiscussions(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getMergeRequestDiscussionsPager(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getMergeRequestDiscussions(Object projectIdOrPath, Integer mergeRequestIid, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getMergeRequestDiscussions(projectIdOrPath, mergeRequestIid);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
        return (List)response.readEntity((GenericType)new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getMergeRequestDiscussionsPager(Object projectIdOrPath, Integer mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
    }

    public Stream<Discussion> getMergeRequestDiscussionsStream(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getMergeRequestDiscussionsPager(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getCommitDiscussions(Object projectIdOrPath, Integer commitId) throws GitLabApiException {
        Pager<Discussion> pager = this.getCommitDiscussionsPager(projectIdOrPath, commitId, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getCommitDiscussions(Object projectIdOrPath, Integer commitId, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getCommitDiscussions(projectIdOrPath, commitId);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "commits", commitId, "discussions");
        return (List)response.readEntity((GenericType)new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getCommitDiscussionsPager(Object projectIdOrPath, Integer commitId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "commits", commitId, "discussions");
    }

    public Stream<Discussion> getCommitDiscussionsStream(Object projectIdOrPath, Integer commitId) throws GitLabApiException {
        Pager<Discussion> pager = this.getCommitDiscussionsPager(projectIdOrPath, commitId, this.getDefaultPerPage());
        return pager.stream();
    }
}

