/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Release;
import org.gitlab4j.api.models.Tag;
import org.gitlab4j.api.utils.FileUtils;

public class TagsApi
extends AbstractApi {
    public TagsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Tag> getTags(Object projectIdOrPath) throws GitLabApiException {
        return this.getTags(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Tag> getTags(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags");
        return (List)response.readEntity((GenericType)new GenericType<List<Tag>>(){});
    }

    public Pager<Tag> getTags(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Tag>(this, Tag.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags");
    }

    public Stream<Tag> getTagsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getTags(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Tag getTag(Object projectIdOrPath, String tagName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags", tagName);
        return (Tag)response.readEntity(Tag.class);
    }

    public Optional<Tag> getOptionalTag(Object projectIdOrPath, String tagName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getTag(projectIdOrPath, tagName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Tag createTag(Object projectIdOrPath, String tagName, String ref) throws GitLabApiException {
        return this.createTag(projectIdOrPath, tagName, ref, null, (String)null);
    }

    public Tag createTag(Object projectIdOrPath, String tagName, String ref, String message, String releaseNotes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("tag_name", tagName, true).withParam("ref", ref, true).withParam("message", message).withParam("release_description", releaseNotes);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags"});
        return (Tag)response.readEntity(Tag.class);
    }

    public Tag createTag(Object projectIdOrPath, String tagName, String ref, String message, File releaseNotesFile) throws GitLabApiException {
        String releaseNotes;
        if (releaseNotesFile != null) {
            try {
                releaseNotes = FileUtils.readFileContents(releaseNotesFile);
            }
            catch (IOException ioe) {
                throw new GitLabApiException(ioe);
            }
        } else {
            releaseNotes = null;
        }
        return this.createTag(projectIdOrPath, tagName, ref, message, releaseNotes);
    }

    public void deleteTag(Object projectIdOrPath, String tagName) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags", tagName);
    }

    public Release createRelease(Object projectIdOrPath, String tagName, String releaseNotes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", releaseNotes);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags", tagName, "release"});
        return (Release)response.readEntity(Release.class);
    }

    public Release updateRelease(Object projectIdOrPath, String tagName, String releaseNotes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", releaseNotes);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tags", tagName, "release");
        return (Release)response.readEntity(Release.class);
    }
}

