/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupProjectsFilter;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.Visibility;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public List<Group> getGroups(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups");
    }

    public List<Group> getGroups(String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public List<Group> getGroups(String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search);
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups");
    }

    public List<Group> getSubGroups(Integer groupId) throws GitLabApiException {
        return this.getSubGroups(groupId, null, null, null, null, null, null, null, 1, this.getDefaultPerPage());
    }

    public List<Group> getSubGroups(Integer groupId, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned) throws GitLabApiException {
        return this.getSubGroups(groupId, skipGroups, allAvailable, search, orderBy, sortOrder, statistics, owned, 1, this.getDefaultPerPage());
    }

    public List<Group> getSubGroups(Integer groupId, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId, "subgroups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getSubGroups(Integer groupId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups", groupId, "subgroups");
    }

    public Pager<Group> getSubGroups(Integer groupId, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned);
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId, "subgroups");
    }

    public List<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
    }

    public List<Project> getProjects(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getProjects(int groupId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", groupId, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(int groupId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "groups", groupId, "projects");
    }

    public Group getGroup(Integer groupId) throws GitLabApiException {
        return this.getGroup(groupId.toString());
    }

    public Optional<Group> getOptionalGroup(Integer groupId) {
        return this.getOptionalGroup(groupId.toString());
    }

    public Group getGroup(String groupPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.urlEncode(groupPath));
        return (Group)response.readEntity(Group.class);
    }

    public Optional<Group> getOptionalGroup(String groupPath) {
        try {
            return Optional.ofNullable(this.getGroup(groupPath));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Group addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName()).withParam("path", group.getPath()).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName()).withParam("path", group.getPath()).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", group.getId());
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Integer groupId, String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Integer groupId, String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public void deleteGroup(Integer groupId) throws GitLabApiException {
        if (groupId == null) {
            throw new RuntimeException("groupId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", groupId);
    }

    public void deleteGroup(Group group) throws GitLabApiException {
        this.deleteGroup(group.getId());
    }

    public List<Member> getMembers(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public List<Member> getMembers(int groupId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getMembers(int groupId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "groups", groupId, "members");
    }

    public Member getMember(int groupId, int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "members", userId);
        return (Member)response.readEntity((GenericType)new GenericType<Member>(){});
    }

    public Optional<Member> getOptionalMember(int groupId, int userId) {
        try {
            return Optional.ofNullable(this.getMember(groupId, userId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Member addMember(Integer groupId, Integer userId, Integer accessLevel) throws GitLabApiException {
        return this.addMember(groupId, userId, accessLevel, null);
    }

    public Member addMember(Integer groupId, Integer userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.addMember(groupId, userId, accessLevel.toValue(), null);
    }

    public Member addMember(Integer groupId, Integer userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.addMember(groupId, userId, accessLevel.toValue(), expiresAt);
    }

    public Member addMember(Integer groupId, Integer userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("user_id", userId, true).withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", groupId, "members"});
        return (Member)response.readEntity(Member.class);
    }

    public Member updateMember(Integer groupId, Integer userId, Integer accessLevel) throws GitLabApiException {
        return this.updateMember(groupId, userId, accessLevel, null);
    }

    public Member updateMember(Integer groupId, Integer userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.updateMember(groupId, userId, accessLevel.toValue(), null);
    }

    public Member updateMember(Integer groupId, Integer userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.updateMember(groupId, userId, accessLevel.toValue(), expiresAt);
    }

    public Member updateMember(Integer groupId, Integer userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId, "members", userId);
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer groupId, Integer userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", groupId, "members", userId);
    }

    public void ldapSync(Object groupIdOrPath) throws GitLabApiException {
        this.post(Response.Status.NO_CONTENT, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_sync"});
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, AccessLevel groupAccess, String provider) throws GitLabApiException {
        if (groupAccess == null) {
            throw new RuntimeException("groupAccess cannot be null or empty");
        }
        this.addLdapGroupLink(groupIdOrPath, cn, groupAccess.toValue(), provider);
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, Integer groupAccess, String provider) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("cn", cn, true).withParam("group_access", groupAccess, true).withParam("provider", provider, true);
        this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links"});
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", cn);
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn, String provider) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        if (provider == null || provider.trim().isEmpty()) {
            throw new RuntimeException("LDAP provider cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", provider, cn);
    }
}

