/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.utils.JacksonJson;

public class GitLabApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Response.StatusType statusInfo;
    private int httpStatus;
    private String message;
    private Map<String, List<String>> validationErrors;

    public GitLabApiException(String message) {
        super(message);
        this.message = message;
    }

    public GitLabApiException(Response response) {
        this.statusInfo = response.getStatusInfo();
        this.httpStatus = response.getStatus();
        if (response.hasEntity()) {
            try {
                String message;
                this.message = message = (String)response.readEntity(String.class);
                MediaType mediaType = response.getMediaType();
                if (mediaType != null && "json".equals(mediaType.getSubtype())) {
                    JsonNode json = JacksonJson.toJsonNode(message);
                    JsonNode jsonMessage = json.get("message");
                    if (jsonMessage != null) {
                        if (jsonMessage.isObject()) {
                            this.validationErrors = new HashMap<String, List<String>>();
                            Iterator fields = jsonMessage.fields();
                            while (fields.hasNext()) {
                                Map.Entry field = (Map.Entry)fields.next();
                                ArrayList<String> values = new ArrayList<String>();
                                this.validationErrors.put((String)field.getKey(), (List<String>)values);
                                for (JsonNode value : (JsonNode)field.getValue()) {
                                    values.add(value.asText());
                                }
                            }
                        } else {
                            this.message = jsonMessage.asText();
                        }
                    } else {
                        JsonNode jsonError = json.get("error");
                        if (jsonError != null) {
                            this.message = jsonError.asText();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public GitLabApiException(Exception e) {
        super(e);
        this.message = e.getMessage();
    }

    @Override
    public final String getMessage() {
        return this.message != null ? this.message : this.getReason();
    }

    public final String getReason() {
        return this.statusInfo != null ? this.statusInfo.getReasonPhrase() : null;
    }

    public final int getHttpStatus() {
        return this.httpStatus;
    }

    public boolean hasValidationErrors() {
        return this.validationErrors != null;
    }

    public Map<String, List<String>> getValidationErrors() {
        return this.validationErrors;
    }
}

