/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Job;
import org.gitlab4j.api.models.JobStatus;
import org.gitlab4j.api.models.Runner;
import org.gitlab4j.api.models.RunnerDetail;

public class RunnersApi
extends AbstractApi {
    public RunnersApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Runner> getRunners() throws GitLabApiException {
        return this.getRunners(null);
    }

    public List<Runner> getRunners(Runner.RunnerStatus scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "runners");
        return (List)response.readEntity((GenericType)new GenericType<List<Runner>>(){});
    }

    public Pager<Runner> getRunners(int itemsPerPage) throws GitLabApiException {
        return this.getRunners(null, itemsPerPage);
    }

    public Pager<Runner> getRunners(Runner.RunnerStatus scope, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, false);
        return new Pager<Runner>(this, Runner.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "runners");
    }

    public List<Runner> getAllRunners() throws GitLabApiException {
        return this.getAllRunners(null);
    }

    public List<Runner> getAllRunners(Runner.RunnerStatus scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "runners", "all");
        return (List)response.readEntity((GenericType)new GenericType<List<Runner>>(){});
    }

    public Pager<Runner> getAllRunners(int itemsPerPage) throws GitLabApiException {
        return this.getAllRunners(null, itemsPerPage);
    }

    public Pager<Runner> getAllRunners(Runner.RunnerStatus scope, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, false);
        return new Pager<Runner>(this, Runner.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "runners");
    }

    public RunnerDetail getRunnerDetail(Integer runnerId) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "runners", runnerId);
        return (RunnerDetail)response.readEntity(RunnerDetail.class);
    }

    public RunnerDetail updateRunner(Integer runnerId, String description, Boolean active, List<String> tagList, Boolean runUntagged, Boolean locked, RunnerDetail.RunnerAccessLevel accessLevel) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("description", description, false).withParam("active", active, false).withParam("tag_list", tagList, false).withParam("run_untagged", runUntagged, false).withParam("locked", locked, false).withParam("access_level", (Object)accessLevel, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "runners", runnerId);
        return (RunnerDetail)response.readEntity(RunnerDetail.class);
    }

    public void removeRunner(Integer runnerId) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "runners", runnerId);
    }

    public List<Job> getJobs(Integer runnerId) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        return this.getJobs(runnerId, null);
    }

    public List<Job> getJobs(Integer runnerId, JobStatus status) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("status", (Object)status, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "runners", runnerId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public Pager<Job> getJobs(Integer runnerId, int itemsPerPage) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        return this.getJobs(runnerId, null, itemsPerPage);
    }

    public Pager<Job> getJobs(Integer runnerId, JobStatus status, int itemsPerPage) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("status", (Object)status, false);
        return new Pager<Job>(this, Job.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "runners", runnerId, "jobs");
    }

    public List<Runner> getProjectRunners(Integer projectId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "runners");
        return (List)response.readEntity((GenericType)new GenericType<List<Runner>>(){});
    }

    public Pager<Runner> getProjectRunners(Integer projectId, int itemsPerPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        return new Pager<Runner>(this, Runner.class, itemsPerPage, null, "projects", projectId, "runners");
    }

    public Runner enableRunner(Integer projectId, Integer runnerId) throws GitLabApiException {
        if (projectId == null || runnerId == null) {
            throw new RuntimeException("projectId or runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("runner_id", runnerId, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", projectId, "runners"});
        return (Runner)response.readEntity(Runner.class);
    }

    public Runner disableRunner(Integer projectId, Integer runnerId) throws GitLabApiException {
        if (projectId == null || runnerId == null) {
            throw new RuntimeException("projectId or runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("runner_id", runnerId, true);
        Response response = this.delete(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "runners");
        return (Runner)response.readEntity(Runner.class);
    }
}

