/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.ProtectedBranch;

public class ProtectedBranchesApi
extends AbstractApi {
    public ProtectedBranchesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<ProtectedBranch> getProtectedBranches(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "protected_branches");
        return (List)response.readEntity((GenericType)new GenericType<List<ProtectedBranch>>(){});
    }

    public void unprotectBranch(Integer projectId, String branchName) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", projectId, "protected_branches", this.urlEncode(branchName));
    }

    public ProtectedBranch protectBranch(Integer projectId, String branchName) throws GitLabApiException {
        return this.protectBranch(projectId, branchName, AccessLevel.MASTER, AccessLevel.MASTER);
    }

    public ProtectedBranch protectBranch(Integer projectId, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", projectId, true).withParam("name", branchName, true).withParam("push_access_level", pushAccessLevel.toValue(), false).withParam("merge_access_level", mergeAccessLevel.toValue(), false);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", projectId, "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }
}

