/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Job;

public class JobApi
extends AbstractApi
implements Constants {
    public JobApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Job> getJobs(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public List<Job> getJobs(int projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public Pager<Job> getJobs(int projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Job>(this, Job.class, itemsPerPage, null, "projects", projectId, "jobs");
    }

    public List<Job> getJobs(int projectId, Constants.JobScope scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public List<Job> getJobsForPipeline(int projectId, int pipelineId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "pipelines", pipelineId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public List<Job> getJobsForPipeline(int projectId, int pipelineId, Constants.JobScope scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "pipelines", pipelineId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public Job getJob(int projectId, int jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "jobs", jobId);
        return (Job)response.readEntity(Job.class);
    }

    public File downloadArtifactsFile(Integer projectId, String ref, String jobName, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "jobs", "artifacts", ref, "download");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = jobName + "-artifacts.zip";
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Integer projectId, String ref, String jobName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "jobs", "artifacts", ref, "download");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public String getTrace(int projectId, int jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "jobs", jobId, "trace");
        return (String)response.readEntity(String.class);
    }

    public Job cancleJob(int projectId, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "jobs", jobId, "cancel");
        return (Job)response.readEntity(Job.class);
    }

    public Job retryJob(int projectId, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "jobs", jobId, "retry");
        return (Job)response.readEntity(Job.class);
    }

    public Job eraseJob(int projectId, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "jobs", jobId, "erase");
        return (Job)response.readEntity(Job.class);
    }

    public Job playJob(int projectId, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "jobs", jobId, "play");
        return (Job)response.readEntity(Job.class);
    }
}

