/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Comment;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.CommitAction;
import org.gitlab4j.api.models.CommitPayload;
import org.gitlab4j.api.models.Diff;
import org.gitlab4j.api.utils.ISO8601;

public class CommitsApi
extends AbstractApi {
    public CommitsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Commit> getCommits(int projectId) throws GitLabApiException {
        return this.getCommits(projectId, null, null, null);
    }

    public List<Commit> getCommits(int projectId, int page, int perPage) throws GitLabApiException {
        return this.getCommits(projectId, null, null, null, page, perPage);
    }

    public Pager<Commit> getCommits(int projectId, int itemsPerPage) throws GitLabApiException {
        return this.getCommits(projectId, null, null, null, itemsPerPage);
    }

    public List<Commit> getCommits(int projectId, String ref, Date since, Date until) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false)).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public List<Commit> getCommits(int projectId, String ref, Date since, Date until, String path) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage()).withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false)).withParam("path", path == null ? null : this.urlEncode(path));
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public List<Commit> getCommits(int projectId, String ref, String path) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage()).withParam("ref_name", ref).withParam("path", path == null ? null : this.urlEncode(path));
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public List<Commit> getCommits(int projectId, String ref, Date since, Date until, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false)).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(int projectId, String ref, Date since, Date until, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref_name", ref).withParam("since", ISO8601.toString(since, false)).withParam("until", ISO8601.toString(until, false));
        return new Pager<Commit>(this, Commit.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "commits");
    }

    public Commit getCommit(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "repository", "commits", sha);
        return (Commit)response.readEntity(Commit.class);
    }

    public List<Diff> getDiff(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits", sha, "diff");
        return (List)response.readEntity((GenericType)new GenericType<List<Diff>>(){});
    }

    public List<Diff> getDiff(String projectPath, String sha) throws GitLabApiException {
        try {
            projectPath = URLEncoder.encode(projectPath, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectPath, "repository", "commits", sha, "diff");
        return (List)response.readEntity((GenericType)new GenericType<List<Diff>>(){});
    }

    public List<Comment> getComments(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits", sha, "comments");
        return (List)response.readEntity((GenericType)new GenericType<List<Comment>>(){});
    }

    public Comment addComment(int projectId, String sha, String note, String path, Integer line, Constants.LineType lineType) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("note", note, true).withParam("path", path).withParam("line", line).withParam("line_type", (Object)lineType);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", projectId, "repository", "commits", sha, "comments"});
        return (Comment)response.readEntity(Comment.class);
    }

    public Comment addComment(int projectId, String sha, String note) throws GitLabApiException {
        return this.addComment(projectId, sha, note, null, null, null);
    }

    public Commit createCommit(int projectId, String branch, String commitMessage, String startBranch, String authorEmail, String authorName, List<CommitAction> actions) throws GitLabApiException {
        CommitPayload payload = new CommitPayload();
        payload.setBranch(branch);
        payload.setCommitMessage(commitMessage);
        payload.setStartBranch(startBranch);
        payload.setAuthorEmail(authorEmail);
        payload.setAuthorName(authorName);
        payload.setActions(actions);
        Response response = this.post(Response.Status.CREATED, payload, "projects", projectId, "repository", "commits");
        return (Commit)response.readEntity(Commit.class);
    }

    public Commit createCommit(String project, String branch, String commitMessage, String startBranch, String authorEmail, String authorName, List<CommitAction> actions) throws GitLabApiException {
        CommitPayload payload = new CommitPayload();
        payload.setBranch(branch);
        payload.setCommitMessage(commitMessage);
        payload.setStartBranch(startBranch);
        payload.setAuthorEmail(authorEmail);
        payload.setAuthorName(authorName);
        payload.setActions(actions);
        Response response = this.post(Response.Status.CREATED, payload, "projects", this.urlEncode(project), "repository", "commits");
        return (Commit)response.readEntity(Commit.class);
    }
}

