/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.DeployKeysApi;
import org.gitlab4j.api.EventsApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.IssuesApi;
import org.gitlab4j.api.JobApi;
import org.gitlab4j.api.MergeRequestApi;
import org.gitlab4j.api.NamespaceApi;
import org.gitlab4j.api.NotesApi;
import org.gitlab4j.api.PipelineApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.ServicesApi;
import org.gitlab4j.api.SessionApi;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.Session;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.models.Version;

public class GitLabApi {
    public static final int DEFAULT_PER_PAGE = 100;
    GitLabApiClient apiClient;
    private ApiVersion apiVersion;
    private int defaultPerPage = 100;
    private CommitsApi commitsApi;
    private DeployKeysApi deployKeysApi;
    private GroupApi groupApi;
    private IssuesApi issuesApi;
    private MergeRequestApi mergeRequestApi;
    private NamespaceApi namespaceApi;
    private PipelineApi pipelineApi;
    private ProjectApi projectApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private ServicesApi servicesApi;
    private SessionApi sessoinApi;
    private UserApi userApi;
    private JobApi jobApi;
    private NotesApi notesApi;
    private EventsApi eventsApi;
    private Session session;

    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(apiVersion, url, username, password, false);
    }

    public static GitLabApi login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, false);
    }

    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        GitLabApi gitLabApi = new GitLabApi(apiVersion, url, (String)null);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        SessionApi sessionApi = gitLabApi.getSessionApi();
        Session session = sessionApi.login(username, null, password);
        gitLabApi = new GitLabApi(apiVersion, url, session);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        return gitLabApi;
    }

    public static GitLabApi login(String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, ignoreCertificateErrors);
    }

    @Deprecated
    public static GitLabApi create(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(url, username, password);
    }

    public Session getSession() {
        return this.session;
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, privateToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken) {
        this(ApiVersion.V4, hostUrl, privateToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Session session) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, session.getPrivateToken(), null);
        this.session = session;
    }

    public GitLabApi(String hostUrl, Session session) {
        this(ApiVersion.V4, hostUrl, session);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.apiVersion = apiVersion;
        this.apiClient = new GitLabApiClient(apiVersion, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
        this.commitsApi = new CommitsApi(this);
        this.deployKeysApi = new DeployKeysApi(this);
        this.eventsApi = new EventsApi(this);
        this.groupApi = new GroupApi(this);
        this.issuesApi = new IssuesApi(this);
        this.jobApi = new JobApi(this);
        this.mergeRequestApi = new MergeRequestApi(this);
        this.namespaceApi = new NamespaceApi(this);
        this.notesApi = new NotesApi(this);
        this.pipelineApi = new PipelineApi(this);
        this.projectApi = new ProjectApi(this);
        this.repositoryApi = new RepositoryApi(this);
        this.repositoryFileApi = new RepositoryFileApi(this);
        this.servicesApi = new ServicesApi(this);
        this.sessoinApi = new SessionApi(this);
        this.userApi = new UserApi(this);
    }

    public void sudo(String sudoAsUsername) throws GitLabApiException {
        if (sudoAsUsername == null || sudoAsUsername.trim().length() == 0) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsUsername);
        if (user == null || user.getId() == null) {
            throw new GitLabApiException("the specified username was not found");
        }
        Integer sudoAsId = user.getId();
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public void unsudo() {
        this.apiClient.setSudoAsId(null);
    }

    public void setSudoAsId(Integer sudoAsId) throws GitLabApiException {
        if (sudoAsId == null) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsId);
        if (user == null || user.getId() != sudoAsId) {
            throw new GitLabApiException("the specified user ID was not found");
        }
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public Integer getSudoAsId() {
        return this.apiClient.getSudoAsId();
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public int getDefaultPerPage() {
        return this.defaultPerPage;
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.defaultPerPage = defaultPerPage;
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public boolean getIgnoreCertificateErrors() {
        return this.apiClient.getIgnoreCertificateErrors();
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.apiClient.setIgnoreCertificateErrors(ignoreCertificateErrors);
    }

    public Version getVersion() throws GitLabApiException {
        class VersionApi
        extends AbstractApi {
            VersionApi(GitLabApi gitlabApi) {
                super(gitlabApi);
            }
        }
        Response response = new VersionApi(this).get(Response.Status.OK, null, "version");
        return (Version)response.readEntity(Version.class);
    }

    public CommitsApi getCommitsApi() {
        return this.commitsApi;
    }

    public DeployKeysApi getDeployKeysApi() {
        return this.deployKeysApi;
    }

    public EventsApi getEventsApi() {
        return this.eventsApi;
    }

    public GroupApi getGroupApi() {
        return this.groupApi;
    }

    public IssuesApi getIssuesApi() {
        return this.issuesApi;
    }

    public JobApi getJobApi() {
        return this.jobApi;
    }

    public MergeRequestApi getMergeRequestApi() {
        return this.mergeRequestApi;
    }

    public NamespaceApi getNamespaceApi() {
        return this.namespaceApi;
    }

    public void setNamespaceApi(NamespaceApi namespaceApi) {
        this.namespaceApi = namespaceApi;
    }

    public NotesApi getNotesApi() {
        return this.notesApi;
    }

    public PipelineApi getPipelineApi() {
        return this.pipelineApi;
    }

    public ProjectApi getProjectApi() {
        return this.projectApi;
    }

    public RepositoryApi getRepositoryApi() {
        return this.repositoryApi;
    }

    public RepositoryFileApi getRepositoryFileApi() {
        return this.repositoryFileApi;
    }

    public ServicesApi getServicesApi() {
        return this.servicesApi;
    }

    public SessionApi getSessionApi() {
        return this.sessoinApi;
    }

    public UserApi getUserApi() {
        return this.userApi;
    }

    public static enum ApiVersion {
        V3,
        V4;


        public String getApiNamespace() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

