/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public class JacksonJsonEnumHelper<E extends Enum<E>> {
    private Map<String, E> valuesMap = new HashMap<String, E>();
    private Map<E, String> namesMap = new HashMap<E, String>();

    public JacksonJsonEnumHelper(Class<E> enumType) {
        this(enumType, false);
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized) {
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            String name = e.name().toLowerCase();
            if (firstLetterCapitalized) {
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            this.valuesMap.put(name, e);
            this.namesMap.put(e, name);
        }
    }

    @JsonCreator
    public E forValue(String value) {
        return (E)((Enum)this.valuesMap.get(value));
    }

    public String toString(E e) {
        return this.namesMap.get(e);
    }
}

