/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.MergeRequest;

public class MergeRequestApi
extends AbstractApi {
    public MergeRequestApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<MergeRequest> getMergeRequests(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public List<MergeRequest> getMergeRequests(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", projectId, "merge_requests");
    }

    public MergeRequest getMergeRequest(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_request", mergeRequestId);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, true);
        this.addFormParam(formData, "target_branch", targetBranch, true);
        this.addFormParam(formData, "title", title, true);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "merge_requests");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest updateMergeRequest(Integer projectId, Integer mergeRequestId, String targetBranch, String title, Integer assigneeId, String description, Constants.StateEvent stateEvent, String labels, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("target_branch", targetBranch).withParam("title", title).withParam("assignee_id", assigneeId).withParam("description", description).withParam("state_event", (Object)stateEvent).withParam("labels", labels).withParam("milestone_id", milestoneId);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_request", mergeRequestId);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    @Deprecated
    public MergeRequest updateMergeRequest(Integer projectId, Integer mergeRequestId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, false);
        this.addFormParam(formData, "target_branch", targetBranch, false);
        this.addFormParam(formData, "title", title, false);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_request", mergeRequestId);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public void deleteMergeRequest(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "merge_request", mergeRequestId);
    }

    public MergeRequest acceptMergeRequest(Integer projectId, Integer mergeRequestId, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_commit_message", mergeCommitMessage).withParam("should_remove_source_branch", shouldRemoveSourceBranch).withParam("merge_when_pipeline_succeeds", mergeWhenPipelineSucceeds);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests", mergeRequestId, "merge");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest cancelMergeRequest(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "merge_requests", mergeRequestId, "cancel_merge_when_pipeline_succeeds");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestApprovals(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_requests", mergeRequestId, "approvals");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest approveMergeRequest(Integer projectId, Integer mergeRequestId, String sha) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.post(Response.Status.OK, (Form)formData, "projects", projectId, "merge_requests", mergeRequestId, "approve");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest unapproveMergeRequest(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Response response = this.post(Response.Status.OK, (Form)null, "projects", projectId, "merge_requests", mergeRequestId, "unapprove");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }
}

