/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.User;

public class UserApi
extends AbstractApi {
    UserApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<User> getUsers() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> getUsers(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getUsers(int itemsPerPage) throws GitLabApiException {
        return new Pager<User>(this, User.class, itemsPerPage, null, "users");
    }

    public User getUser(int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", userId);
        return (User)response.readEntity(User.class);
    }

    public List<User> findUsers(String emailOrUsername) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> findUsers(String emailOrUsername, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> findUsers(String emailOrUsername, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public User createUser(User user, String password, Integer projectsLimit) throws GitLabApiException {
        Form formData = this.userToForm(user, projectsLimit, password, true);
        Response response = this.post(Response.Status.CREATED, formData, "users");
        return (User)response.readEntity(User.class);
    }

    public User modifyUser(User user, String password, Integer projectsLimit) throws GitLabApiException {
        Form form = this.userToForm(user, projectsLimit, password, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "users", user.getId());
        return (User)response.readEntity(User.class);
    }

    public void deleteUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "users", userId);
    }

    public void deleteUser(User user) throws GitLabApiException {
        this.deleteUser(user.getId());
    }

    Form userToForm(User user, Integer projectsLimit, String password, boolean create) {
        return new GitLabApiForm().withParam("email", user.getEmail(), create).withParam("password", password, create).withParam("username", user.getUsername(), create).withParam("name", user.getName(), create).withParam("skype", user.getSkype(), false).withParam("linkedin", user.getLinkedin(), false).withParam("twitter", user.getTwitter(), false).withParam("website_url", user.getWebsiteUrl(), false).withParam("projects_limit", projectsLimit, false).withParam("external", user.getExternal(), false).withParam("provider", user.getProvider(), false).withParam("bio", user.getBio(), false).withParam("location", user.getLocation(), false).withParam("admin", user.getIsAdmin(), false).withParam("can_create_group", user.getCanCreateGroup(), false).withParam("external", user.getExternal(), false);
    }
}

