/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.Event;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectHook;
import org.gitlab4j.api.models.Visibility;

public class ProjectApi
extends AbstractApi
implements Constants {
    public ProjectApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Project> getProjects() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getProjects(Boolean archived, Visibility visibility, String orderBy, String sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("archived", archived).withParam("visibility", (Object)visibility).withParam("order_by", orderBy).withParam("sort", sort).withParam("search", search).withParam("simple", simple).withParam("owned", owned).withParam("membership", membership).withParam("starred", starred).withParam("statistics", statistics).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getProjects(Boolean archived, Visibility visibility, Constants.ProjectOrderBy orderBy, Constants.SortOrder sort, String search, Boolean simple, Boolean owned, Boolean membership, Boolean starred, Boolean statistics) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("archived", archived).withParam("visibility", (Object)visibility).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("search", search).withParam("simple", simple).withParam("owned", owned).withParam("membership", membership).withParam("starred", starred).withParam("statistics", statistics).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getProjects(String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getMemberProjects() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("membership", true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getAllProjects() throws GitLabApiException {
        if (!this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            throw new GitLabApiException("Not supported by GitLab API version " + (Object)((Object)this.getApiVersion()));
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", "all");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getOwnedProjects() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getStarredProjects() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("starred", true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Project getProject(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId);
        return (Project)response.readEntity(Project.class);
    }

    public Project getProject(String namespace, String project) throws GitLabApiException {
        if (namespace == null) {
            throw new RuntimeException("namespace cannot be null");
        }
        if (project == null) {
            throw new RuntimeException("project cannot be null");
        }
        String projectPath = null;
        try {
            projectPath = URLEncoder.encode(namespace + "/" + project, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectPath);
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Integer groupId, String projectName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("namespace_id", groupId).withParam("name", projectName, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String projectName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", projectName, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(Project project) throws GitLabApiException {
        return this.createProject(project, null);
    }

    public Project createProject(Project project, String importUrl) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        String name = project.getName();
        String path = project.getPath();
        if (!(name != null && name.trim().length() != 0 || path != null && path.trim().length() != 0)) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("default_branch", project.getDefaultBranch()).withParam("description", project.getDescription()).withParam("issues_enabled", project.getIssuesEnabled()).withParam("merge_requests_enabled", project.getMergeRequestsEnabled()).withParam("jobs_enabled", project.getJobsEnabled()).withParam("wiki_enabled", project.getWikiEnabled()).withParam("container_registry_enabled", project.getContainerRegistryEnabled()).withParam("snippets_enabled", project.getSnippetsEnabled()).withParam("shared_runners_enabled", project.getSharedRunnersEnabled()).withParam("public_jobs", project.getPublicJobs()).withParam("visibility_level", project.getVisibilityLevel()).withParam("only_allow_merge_if_pipeline_succeeds", project.getOnlyAllowMergeIfPipelineSucceeds()).withParam("only_allow_merge_if_all_discussions_are_resolved", project.getOnlyAllowMergeIfAllDiscussionsAreResolved()).withParam("lfs_enabled", project.getLfsEnabled()).withParam("request_access_enabled", project.getRequestAccessEnabled()).withParam("repository_storage", project.getRepositoryStorage()).withParam("approvals_before_merge", project.getApprovalsBeforeMerge()).withParam("import_url", importUrl);
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            boolean isPublic = project.getPublic() != null ? project.getPublic() : project.getVisibility() == Visibility.PUBLIC;
            formData.withParam("public", isPublic);
        } else {
            Visibility visibility = project.getVisibility() != null ? project.getVisibility() : (project.getPublic() == Boolean.TRUE ? Visibility.PUBLIC : null);
            formData.withParam("visibility", (Object)visibility);
        }
        if (project.getNamespace() != null) {
            formData.withParam("namespace_id", project.getNamespace().getId());
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public Project createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Visibility visibility, Integer visibilityLevel, String importUrl) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            Boolean isPublic = Visibility.PUBLIC == visibility;
            return this.createProject(name, namespaceId, description, issuesEnabled, mergeRequestsEnabled, wikiEnabled, snippetsEnabled, isPublic, visibilityLevel, importUrl);
        }
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("namespace_id", namespaceId).withParam("description", description).withParam("issues_enabled", issuesEnabled).withParam("merge_requests_enabled", mergeRequestsEnabled).withParam("wiki_enabled", wikiEnabled).withParam("snippets_enabled", snippetsEnabled).withParam("visibility_level", visibilityLevel).withParam("visibility", (Object)visibility).withParam("import_url", importUrl);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    @Deprecated
    public Project createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean isPublic, Integer visibilityLevel, String importUrl) throws GitLabApiException {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("namespace_id", namespaceId).withParam("description", description).withParam("issues_enabled", issuesEnabled).withParam("merge_requests_enabled", mergeRequestsEnabled).withParam("wiki_enabled", wikiEnabled).withParam("snippets_enabled", snippetsEnabled).withParam("visibility_level", visibilityLevel).withParam("import_url", importUrl);
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            formData.withParam("public", isPublic);
        } else if (isPublic.booleanValue()) {
            formData.withParam("visibility", (Object)Visibility.PUBLIC);
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects");
        return (Project)response.readEntity(Project.class);
    }

    public void deleteProject(Integer projectId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.ACCEPTED;
        this.delete(expectedStatus, null, "projects", projectId);
    }

    public void deleteProject(Project project) throws GitLabApiException {
        this.deleteProject(project.getId());
    }

    public List<Member> getMembers(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Member getMember(Integer projectId, Integer userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "members", userId);
        return (Member)response.readEntity(Member.class);
    }

    public Member addMember(Integer projectId, Integer userId, Integer accessLevel) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("user_id", userId, true).withParam("access_level", accessLevel, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", projectId, "members");
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer projectId, Integer userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "members", userId);
    }

    public List<Event> getProjectEvents(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public List<ProjectHook> getHooks(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "hooks");
        return (List)response.readEntity((GenericType)new GenericType<List<ProjectHook>>(){});
    }

    public ProjectHook getHook(Integer projectId, Integer hookId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "hooks", hookId);
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public ProjectHook addHook(String projectName, String url, ProjectHook enabledHooks, boolean enableSslVerification, String secretToken) throws GitLabApiException {
        if (projectName == null) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("push_events", enabledHooks.getPushEvents(), false).withParam("issues_events", enabledHooks.getIssuesEvents(), false).withParam("merge_requests_events", enabledHooks.getMergeRequestsEvents(), false).withParam("tag_push_events", enabledHooks.getTagPushEvents(), false).withParam("note_events", enabledHooks.getNoteEvents(), false).withParam("job_events", enabledHooks.getJobEvents(), false).withParam("pipeline_events", enabledHooks.getPipelineEvents(), false).withParam("wiki_events", enabledHooks.getWikiPageEvents(), false).withParam("enable_ssl_verification", enabledHooks.getEnableSslVerification()).withParam("token", secretToken, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", projectName, "hooks");
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public ProjectHook addHook(Integer projectId, String url, ProjectHook enabledHooks, boolean enableSslVerification, String secretToken) throws GitLabApiException {
        if (projectId == null) {
            return null;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("push_events", enabledHooks.getPushEvents(), false).withParam("issues_events", enabledHooks.getIssuesEvents(), false).withParam("merge_requests_events", enabledHooks.getMergeRequestsEvents(), false).withParam("tag_push_events", enabledHooks.getTagPushEvents(), false).withParam("note_events", enabledHooks.getNoteEvents(), false).withParam("job_events", enabledHooks.getJobEvents(), false).withParam("pipeline_events", enabledHooks.getPipelineEvents(), false).withParam("wiki_events", enabledHooks.getWikiPageEvents(), false).withParam("enable_ssl_verification", enabledHooks.getEnableSslVerification()).withParam("token", secretToken, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", projectId, "hooks");
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public ProjectHook addHook(Project project, String url, ProjectHook enabledHooks, boolean enableSslVerification, String secretToken) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        return this.addHook(project.getId(), url, enabledHooks, enableSslVerification, secretToken);
    }

    public ProjectHook addHook(Project project, String url, boolean doPushEvents, boolean doIssuesEvents, boolean doMergeRequestsEvents) throws GitLabApiException {
        if (project == null) {
            return null;
        }
        return this.addHook(project.getId(), url, doPushEvents, doIssuesEvents, doMergeRequestsEvents);
    }

    public ProjectHook addHook(Integer projectId, String url, boolean doPushEvents, boolean doIssuesEvents, boolean doMergeRequestsEvents) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url).withParam("push_events", doPushEvents).withParam("issues_enabled", doIssuesEvents).withParam("merge_requests_events", doMergeRequestsEvents);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", projectId, "hooks");
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public void deleteHook(Integer projectId, Integer hookId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "hooks", hookId);
    }

    public void deleteHook(ProjectHook hook) throws GitLabApiException {
        this.deleteHook(hook.getProjectId(), hook.getId());
    }

    public ProjectHook modifyHook(ProjectHook hook) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("url", hook.getUrl(), true).withParam("push_events", hook.getPushEvents(), false).withParam("issues_events", hook.getIssuesEvents(), false).withParam("merge_requests_events", hook.getMergeRequestsEvents(), false).withParam("tag_push_events", hook.getTagPushEvents(), false).withParam("note_events", hook.getNoteEvents(), false).withParam("job_events", hook.getJobEvents(), false).withParam("pipeline_events", hook.getPipelineEvents(), false).withParam("wiki_events", hook.getWikiPageEvents(), false).withParam("enable_ssl_verification", hook.getEnableSslVerification(), false).withParam("token", hook.getToken(), false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", hook.getProjectId(), "hooks", hook.getId());
        return (ProjectHook)response.readEntity(ProjectHook.class);
    }

    public List<Issue> getIssues(Integer projectId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public List<Issue> getIssues(Integer projectId, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("page", page, false).withParam("per_page", perPage, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }
}

