/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.Member;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Group getGroup(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public void addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        this.post(Response.Status.CREATED, formData, "groups");
    }

    public void deleteGroup(Integer groupId) throws GitLabApiException {
        if (groupId == null) {
            throw new RuntimeException("groupId cannot be null");
        }
        this.delete(Response.Status.OK, null, "groups", groupId);
    }

    public void deleteGroup(Group group) throws GitLabApiException {
        this.deleteGroup(group.getId());
    }

    public List<Member> getMembers(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Member addMember(Integer groupId, Integer userId, Integer accessLevel) throws GitLabApiException {
        Form formData = new Form();
        formData.param("user_id", userId.toString());
        formData.param("access_level", accessLevel.toString());
        Response response = this.post(Response.Status.OK, formData, "groups", groupId, "members");
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer projectId, Integer userId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "groups", projectId, "members", userId);
    }
}

